/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.parameters;

import java.util.Collections;
import org.gradle.internal.event.ListenerNotificationException;
import org.gradle.tooling.StreamedValueListener;
import org.jspecify.annotations.Nullable;

public class FailsafeStreamedValueListener
implements StreamedValueListener {
    private final @Nullable StreamedValueListener delegate;
    private RuntimeException failure;

    public FailsafeStreamedValueListener(@Nullable StreamedValueListener delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onValue(Object value) {
        if (this.failure != null) {
            return;
        }
        if (this.delegate != null) {
            try {
                this.delegate.onValue(value);
            }
            catch (Throwable e) {
                this.failure = new ListenerNotificationException(null, "Streaming model listener failed with an exception.", Collections.singletonList(e));
            }
        } else {
            this.failure = new IllegalStateException("No streaming model listener registered.");
        }
    }

    public void rethrowErrors() {
        if (this.failure != null) {
            throw this.failure;
        }
    }
}

