/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.search.impl;

import java.util.ArrayList;
import java.util.List;
import org.gephi.desktop.search.impl.SearchResultImpl;
import org.gephi.desktop.search.spi.SearchProvider;
import org.gephi.desktop.search.spi.SearchResultsBuilder;

public class SearchResultsBuilderImpl<T>
implements SearchResultsBuilder<T> {
    private boolean obsolete = false;
    private final int maxResults;
    private final List<SearchResultImpl<T>> resultsList;
    private final SearchProvider<T> provider;
    private int position;

    public SearchResultsBuilderImpl(SearchProvider<T> provider, int position, int maxResults) {
        this.provider = provider;
        this.position = position;
        this.maxResults = maxResults;
        this.resultsList = new ArrayList<SearchResultImpl<T>>();
    }

    @Override
    public synchronized boolean addResult(T result, String htmlDisplayText, String matchLocation) {
        if (result == null) {
            throw new NullPointerException("Result cannot be null");
        }
        this.resultsList.add(new SearchResultImpl<T>(this.provider, this.position, result, htmlDisplayText, matchLocation));
        return !this.obsolete && this.resultsList.size() < this.maxResults;
    }

    @Override
    public boolean isObsolete() {
        return this.obsolete;
    }

    protected List<SearchResultImpl<T>> getResults() {
        return this.resultsList;
    }

    protected void markObsolete() {
        this.obsolete = true;
    }
}

