/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.read;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.model.output.structured.Description;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.freeplane.plugin.ai.tools.read.ContextSection;

public class ReadNodesWithDescendantsRequest {
    private static final int DEFAULT_FULL_CONTENT_DEPTH = 0;
    private static final int DEFAULT_SUMMARY_DEPTH = 1;
    private static final int DEFAULT_MAXIMUM_TOTAL_TEXT_CHARACTERS = 65536;
    @Description(value={"Target map ID (from getSelectedMapAndNodeIdentifiers)."})
    private final String mapIdentifier;
    @JsonProperty(required=false)
    @Description(value={"Node IDs to read (default: root)."})
    private final List<String> nodeIdentifiers;
    @JsonProperty(required=false)
    @Description(value={"Extra sections (default: none). QUALIFIERS adds summary_node/first_group_node."})
    private final List<ContextSection> contextSections;
    @JsonProperty(required=false)
    @Description(value={"Depth of full content (default: 0)."})
    private final Integer fullContentDepth;
    @JsonProperty(required=false)
    @Description(value={"Summary depth beyond fullContentDepth (default: 1)."})
    private final Integer summaryDepth;
    @JsonProperty(required=false)
    @Description(value={"Maximum response length in characters (default: 65536)."})
    private final Integer maximumTotalTextCharacters;
    private final boolean hasFullContentDepth;
    private final boolean hasSummaryDepth;
    private final boolean hasMaximumTotalTextCharacters;

    @JsonCreator
    public ReadNodesWithDescendantsRequest(@JsonProperty(value="mapIdentifier") String mapIdentifier, @JsonProperty(value="nodeIdentifiers") List<String> nodeIdentifiers, @JsonProperty(value="contextSections") List<ContextSection> contextSections, @JsonProperty(value="fullContentDepth") Integer fullContentDepth, @JsonProperty(value="summaryDepth") Integer summaryDepth, @JsonProperty(value="maximumTotalTextCharacters") Integer maximumTotalTextCharacters) {
        this.mapIdentifier = mapIdentifier;
        this.nodeIdentifiers = nodeIdentifiers;
        this.contextSections = ReadNodesWithDescendantsRequest.normalizeContextSections(contextSections);
        this.hasFullContentDepth = fullContentDepth != null;
        this.fullContentDepth = fullContentDepth == null ? 0 : fullContentDepth;
        this.hasSummaryDepth = summaryDepth != null;
        this.summaryDepth = summaryDepth == null ? 1 : summaryDepth;
        this.hasMaximumTotalTextCharacters = maximumTotalTextCharacters != null;
        this.maximumTotalTextCharacters = maximumTotalTextCharacters == null ? 65536 : maximumTotalTextCharacters;
    }

    public String getMapIdentifier() {
        return this.mapIdentifier;
    }

    public List<String> getNodeIdentifiers() {
        return this.nodeIdentifiers;
    }

    public List<ContextSection> getContextSections() {
        return this.contextSections;
    }

    public Integer getFullContentDepth() {
        return this.fullContentDepth;
    }

    public Integer getSummaryDepth() {
        return this.summaryDepth;
    }

    public Integer getMaximumTotalTextCharacters() {
        return this.maximumTotalTextCharacters;
    }

    public boolean hasFullContentDepth() {
        return this.hasFullContentDepth;
    }

    public boolean hasSummaryDepth() {
        return this.hasSummaryDepth;
    }

    public boolean hasMaximumTotalTextCharacters() {
        return this.hasMaximumTotalTextCharacters;
    }

    private static List<ContextSection> normalizeContextSections(List<ContextSection> contextSections) {
        if (contextSections == null || contextSections.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ContextSection> normalized = new ArrayList<ContextSection>();
        for (ContextSection section : contextSections) {
            if (section == null) continue;
            normalized.add(section);
        }
        if (normalized.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(normalized);
    }
}

