/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.edit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.model.output.structured.Description;
import org.freeplane.plugin.ai.tools.content.ContentType;
import org.freeplane.plugin.ai.tools.edit.EditOperation;
import org.freeplane.plugin.ai.tools.edit.EditedElement;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NodeContentEditItem {
    @Description(value={"Node ID to edit."})
    private final String nodeIdentifier;
    private final EditedElement editedElement;
    @JsonProperty(value="originalContentType")
    @Description(value={"Original content type from fetchNodesForEditing."})
    private final ContentType originalContentType;
    @JsonProperty(required=false)
    @Description(value={"New value. For PLAIN_TEXT formatting use HTML; Markdown is literal unless originalContentType is MARKDOWN."})
    private final String value;
    @JsonProperty(required=false)
    private final Integer index;
    @JsonProperty(required=false)
    @Description(value={"Operations: TEXT=REPLACE; DETAILS/NOTE=REPLACE or DELETE; ATTRIBUTES/TAGS/ICONS=ADD/REPLACE/DELETE; HYPERLINK=REPLACE/DELETE."})
    private final EditOperation operation;
    @JsonProperty(required=false)
    private final String targetKey;
    @JsonProperty(required=false)
    @Description(value={"Hyperlink value when editedElement is HYPERLINK."})
    private final String hyperlink;

    @JsonCreator
    public NodeContentEditItem(@JsonProperty(value="nodeIdentifier") String nodeIdentifier, @JsonProperty(value="editedElement") EditedElement editedElement, @JsonProperty(value="originalContentType") ContentType originalContentType, @JsonProperty(value="value") String value, @JsonProperty(value="index") Integer index, @JsonProperty(value="operation") EditOperation operation, @JsonProperty(value="targetKey") String targetKey, @JsonProperty(value="hyperlink") String hyperlink) {
        this.nodeIdentifier = nodeIdentifier;
        this.editedElement = editedElement;
        this.originalContentType = originalContentType;
        this.value = value;
        this.index = index;
        this.operation = operation == null ? EditOperation.REPLACE : operation;
        this.targetKey = targetKey;
        this.hyperlink = hyperlink;
    }

    public EditedElement getEditedElement() {
        return this.editedElement;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public ContentType getOriginalContentType() {
        return this.originalContentType;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getIndex() {
        return this.index;
    }

    public EditOperation getOperation() {
        return this.operation;
    }

    public String getTargetKey() {
        return this.targetKey;
    }

    public String getHyperlink() {
        return this.hyperlink;
    }
}

