/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import javax.swing.ImageIcon;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.util.Utils;

public class ChoiceItem<T>
implements Comparable<ChoiceItem<T>> {
    private String text;
    private final T object;
    private ImageIcon icon;
    private boolean enabled;
    private boolean optionOK = false;
    private boolean optionCancel = false;
    private boolean optionDefault = false;

    public ChoiceItem(String text, T object, boolean enable) {
        this.text = text;
        this.object = object;
        this.icon = null;
        this.enabled = enable;
        this.optionDefault = false;
        this.optionCancel = false;
        this.optionOK = false;
    }

    public ChoiceItem(String text, T object) {
        this(text, object, true);
    }

    public ChoiceItem(T object) {
        this(Messages.message(object.toString()), object, true);
        if (object instanceof AbstractGoods) {
            this.text = Messages.message(((AbstractGoods)object).getLabel());
        } else if (object instanceof AbstractUnit) {
            this.text = Messages.message(((AbstractUnit)object).getId());
        } else if (object instanceof Player) {
            this.text = Messages.message(((Player)object).getLabel());
        }
    }

    public T getObject() {
        return this.object;
    }

    public int getChoice() {
        return (Integer)this.object;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean setEnabled(boolean enable) {
        boolean ret = this.enabled;
        this.enabled = enable;
        return ret;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public ChoiceItem<T> setIcon(ImageIcon icon) {
        this.icon = icon;
        return this;
    }

    public boolean isOK() {
        return this.optionOK;
    }

    public ChoiceItem<T> okOption() {
        this.optionOK = true;
        return this;
    }

    public boolean isCancel() {
        return this.optionCancel;
    }

    public ChoiceItem<T> cancelOption() {
        this.optionCancel = true;
        return this;
    }

    public boolean isDefault() {
        return this.optionDefault;
    }

    public ChoiceItem<T> defaultOption() {
        this.optionDefault = true;
        return this;
    }

    @Override
    public int compareTo(ChoiceItem<T> other) {
        return this.text == null ? -1 : (other.text == null ? 1 : this.text.compareTo(other.text));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ChoiceItem) {
            ChoiceItem other = (ChoiceItem)o;
            return Utils.equals(this.text, other.toString()) && Utils.equals(this.getObject(), other.getObject());
        }
        return false;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Utils.hashCode(this.text);
        hash = 31 * hash + Utils.hashCode(this.object);
        hash = 31 * hash + (this.enabled ? 1 : 0);
        hash = 31 * hash + (this.optionOK ? 1 : 0);
        hash = 31 * hash + (this.optionCancel ? 1 : 0);
        hash = 31 * hash + (this.optionDefault ? 1 : 0);
        return hash;
    }

    public String toString() {
        return this.text;
    }
}

