/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.PyPsiIndexUtil;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PyRemoveParameterQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.remove.parameter", new Object[0]);
        if (string == null) {
            PyRemoveParameterQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            PyRemoveParameterQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            PyRemoveParameterQuickFix.$$$reportNull$$$0(2);
        }
        PyParameter psi = PyUtil.as(descriptor2.getPsiElement(), PyParameter.class);
        assert (psi != null);
        PyCallableParameter parameter = PyCallableParameterImpl.psi(psi);
        TypeEvalContext ctx = TypeEvalContext.codeAnalysis(project, psi.getContainingFile());
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)psi, PyFunction.class);
        if (function != null) {
            PyResolveContext resolveContext = PyResolveContext.defaultContext(ctx);
            ((StreamEx)StreamEx.of(PyPsiIndexUtil.findUsages((PsiNamedElement)function, false)).map(UsageInfo::getElement).nonNull().map(PsiElement::getParent).select(PyCallExpression.class).flatCollection(callExpression -> callExpression.multiMapArguments(resolveContext)).flatCollection(mapping -> mapping.getMappedParameters().entrySet()).filter(entry -> parameter.equals(entry.getValue()))).forEach(entry -> ((PyExpression)entry.getKey()).delete());
            PyStringLiteralExpression docStringExpression = function.getDocStringExpression();
            String parameterName = parameter.getName();
            if (docStringExpression != null && parameterName != null) {
                PyDocstringGenerator.forDocStringOwner(function).withoutParam(parameterName).buildAndInsert();
            }
            if (parameterName != null) {
                StreamEx.of(PyiUtil.getOverloads(function, ctx)).map(overload -> overload.getParameterList().getParameters()).map(parameters -> (PyParameter)ContainerUtil.find((Object[])parameters, overloadParameter -> parameterName.equals(overloadParameter.getName()))).nonNull().forEach(PsiElement::delete);
            }
        }
        psi.delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyRemoveParameterQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyRemoveParameterQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

