/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Booleans;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.JavaInput;
import com.sun.tools.javac.parser.Tokens;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public class ImportOrderer {
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    private static final ImmutableSet<Tokens.TokenKind> CLASS_START = ImmutableSet.of((Object)Tokens.TokenKind.CLASS, (Object)Tokens.TokenKind.INTERFACE, (Object)Tokens.TokenKind.ENUM);
    private static final ImmutableSet<String> IMPORT_OR_CLASS_START = ImmutableSet.of((Object)"import", (Object)"class", (Object)"interface", (Object)"enum");
    private static final Comparator<Import> GOOGLE_IMPORT_COMPARATOR = Comparator.comparing(Import::importType).thenComparing(Import::imported);
    private static final Comparator<Import> AOSP_IMPORT_COMPARATOR = Comparator.comparing(Import::importType).thenComparing(Import::isAndroid, Booleans.trueFirst()).thenComparing(Import::isThirdParty, Booleans.trueFirst()).thenComparing(Import::isJava, Booleans.trueFirst()).thenComparing(Import::imported);
    private final String text;
    private final ImmutableList<JavaInput.Tok> toks;
    private final String lineSeparator;
    private final Comparator<Import> importComparator;
    private final BiFunction<Import, Import, Boolean> shouldInsertBlankLineFn;

    public static String reorderImports(String text, JavaFormatterOptions.Style style) throws FormatterException {
        ImmutableList<JavaInput.Tok> toks = JavaInput.buildToks(text, CLASS_START);
        return new ImportOrderer(text, toks, style).reorderImports();
    }

    @Deprecated
    public static String reorderImports(String text) throws FormatterException {
        return ImportOrderer.reorderImports(text, JavaFormatterOptions.Style.GOOGLE);
    }

    private String reorderImports() throws FormatterException {
        Optional<Integer> maybeFirstImport = this.findIdentifier(0, IMPORT_OR_CLASS_START);
        if (!maybeFirstImport.isPresent() || !this.tokenAt(maybeFirstImport.get()).equals("import")) {
            return this.text;
        }
        int firstImportStart = maybeFirstImport.get();
        int unindentedFirstImportStart = this.unindent(firstImportStart);
        ImportsAndIndex imports = this.scanImports(firstImportStart);
        int afterLastImport = imports.index;
        Optional<Integer> maybeLaterImport = this.findIdentifier(afterLastImport, IMPORT_OR_CLASS_START);
        if (maybeLaterImport.isPresent() && this.tokenAt(maybeLaterImport.get()).equals("import")) {
            throw new FormatterException("Imports not contiguous (perhaps a comment separates them?)");
        }
        StringBuilder result = new StringBuilder();
        String prefix = this.tokString(0, unindentedFirstImportStart);
        result.append(prefix);
        if (!prefix.isEmpty() && Newlines.getLineEnding(prefix) == null) {
            result.append(this.lineSeparator).append(this.lineSeparator);
        }
        result.append(this.reorderedImportsString(imports.imports));
        ArrayList<String> tail = new ArrayList<String>();
        tail.add(CharMatcher.whitespace().trimLeadingFrom((CharSequence)this.tokString(afterLastImport, this.toks.size())));
        if (!this.toks.isEmpty()) {
            JavaInput.Tok lastTok = (JavaInput.Tok)Iterables.getLast(this.toks);
            int tailStart = lastTok.getPosition() + lastTok.length();
            tail.add(this.text.substring(tailStart));
        }
        if (tail.stream().anyMatch(s -> !s.isEmpty())) {
            result.append(this.lineSeparator);
            tail.forEach(result::append);
        }
        return result.toString();
    }

    private static boolean shouldInsertBlankLineGoogle(Import prev, Import curr) {
        return !prev.importType().equals((Object)curr.importType());
    }

    private static boolean shouldInsertBlankLineAosp(Import prev, Import curr) {
        if (!prev.importType().equals((Object)curr.importType())) {
            return true;
        }
        if (prev.isAndroid() && !curr.isAndroid()) {
            return true;
        }
        return !prev.topLevel().equals(curr.topLevel());
    }

    private ImportOrderer(String text, ImmutableList<JavaInput.Tok> toks, JavaFormatterOptions.Style style) {
        this.text = text;
        this.toks = toks;
        this.lineSeparator = Newlines.guessLineSeparator(text);
        if (style.equals((Object)JavaFormatterOptions.Style.GOOGLE)) {
            this.importComparator = GOOGLE_IMPORT_COMPARATOR;
            this.shouldInsertBlankLineFn = ImportOrderer::shouldInsertBlankLineGoogle;
        } else if (style.equals((Object)JavaFormatterOptions.Style.AOSP)) {
            this.importComparator = AOSP_IMPORT_COMPARATOR;
            this.shouldInsertBlankLineFn = ImportOrderer::shouldInsertBlankLineAosp;
        } else {
            throw new IllegalArgumentException("Unsupported code style: " + String.valueOf((Object)style));
        }
    }

    private String tokString(int start, int end) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < end; ++i) {
            sb.append(((JavaInput.Tok)this.toks.get(i)).getOriginalText());
        }
        return sb.toString();
    }

    private ImportsAndIndex scanImports(int i) throws FormatterException {
        int afterLastImport = i;
        ImmutableSortedSet.Builder imports = ImmutableSortedSet.orderedBy(this.importComparator);
        while (i < this.toks.size() && this.tokenAt(i).equals("import")) {
            ImportType importType;
            if (this.isSpaceToken(++i)) {
                ++i;
            }
            switch (this.tokenAt(i)) {
                case "static": {
                    ImportType importType2 = ImportType.STATIC;
                    break;
                }
                case "module": {
                    ImportType importType2 = ImportType.MODULE;
                    break;
                }
                default: {
                    ImportType importType2 = importType = ImportType.NORMAL;
                }
            }
            if (!importType.equals((Object)ImportType.NORMAL) && this.isSpaceToken(++i)) {
                ++i;
            }
            if (!this.isIdentifierToken(i)) {
                throw new FormatterException("Unexpected token after import: " + this.tokenAt(i));
            }
            StringAndIndex imported = this.scanImported(i);
            String importedName = imported.string;
            i = imported.index;
            if (this.isSpaceToken(i)) {
                ++i;
            }
            if (!this.tokenAt(i).equals(";")) {
                throw new FormatterException("Expected ; after import");
            }
            while (this.tokenAt(i).equals(";")) {
                ++i;
            }
            StringBuilder trailing = new StringBuilder();
            if (this.isSpaceToken(i)) {
                trailing.append(this.tokenAt(i));
                ++i;
            }
            if (this.isNewlineToken(i)) {
                trailing.append(this.tokenAt(i));
                ++i;
            }
            while (this.isSlashSlashCommentToken(i)) {
                trailing.append(this.tokenAt(i));
                if (!this.isNewlineToken(++i)) continue;
                trailing.append(this.tokenAt(i));
                ++i;
            }
            while (this.tokenAt(i).equals(";")) {
                ++i;
            }
            imports.add((Object)new Import(importedName, trailing.toString(), importType));
            afterLastImport = i;
            while (this.isNewlineToken(i) || this.isSpaceToken(i)) {
                ++i;
            }
        }
        return new ImportsAndIndex((ImmutableSortedSet<Import>)imports.build(), afterLastImport);
    }

    private String reorderedImportsString(ImmutableSortedSet<Import> imports) {
        Preconditions.checkArgument((!imports.isEmpty() ? 1 : 0) != 0, (Object)"imports");
        Import prevImport = (Import)imports.iterator().next();
        StringBuilder sb = new StringBuilder();
        for (Import currImport : imports) {
            if (this.shouldInsertBlankLineFn.apply(prevImport, currImport).booleanValue()) {
                sb.append(this.lineSeparator);
            }
            sb.append(currImport);
            prevImport = currImport;
        }
        return sb.toString();
    }

    private StringAndIndex scanImported(int start) throws FormatterException {
        int i = start;
        StringBuilder imported = new StringBuilder();
        do {
            Preconditions.checkState((boolean)this.isIdentifierToken(i));
            imported.append(this.tokenAt(i));
            if (!this.tokenAt(++i).equals(".")) {
                return new StringAndIndex(imported.toString(), i);
            }
            imported.append('.');
            if (!this.tokenAt(++i).equals("*")) continue;
            imported.append('*');
            return new StringAndIndex(imported.toString(), i + 1);
        } while (this.isIdentifierToken(i));
        throw new FormatterException("Could not parse imported name, at: " + this.tokenAt(i));
    }

    private Optional<Integer> findIdentifier(int start, ImmutableSet<String> identifiers) {
        for (int i = start; i < this.toks.size(); ++i) {
            String id;
            if (!this.isIdentifierToken(i) || !identifiers.contains((Object)(id = this.tokenAt(i)))) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    private int unindent(int i) {
        if (i > 0 && this.isSpaceToken(i - 1)) {
            return i - 1;
        }
        return i;
    }

    private String tokenAt(int i) {
        return ((JavaInput.Tok)this.toks.get(i)).getOriginalText();
    }

    private boolean isIdentifierToken(int i) {
        String s = this.tokenAt(i);
        return !s.isEmpty() && Character.isJavaIdentifierStart(s.codePointAt(0));
    }

    private boolean isSpaceToken(int i) {
        String s = this.tokenAt(i);
        if (s.isEmpty()) {
            return false;
        }
        return " \t\f".indexOf(s.codePointAt(0)) >= 0;
    }

    private boolean isSlashSlashCommentToken(int i) {
        return ((JavaInput.Tok)this.toks.get(i)).isSlashSlashComment();
    }

    private boolean isNewlineToken(int i) {
        return ((JavaInput.Tok)this.toks.get(i)).isNewline();
    }

    private static class ImportsAndIndex {
        final ImmutableSortedSet<Import> imports;
        final int index;

        ImportsAndIndex(ImmutableSortedSet<Import> imports, int index) {
            this.imports = imports;
            this.index = index;
        }
    }

    class Import {
        private final String imported;
        private final String trailing;
        private final ImportType importType;

        Import(String imported, String trailing, ImportType importType) {
            this.imported = imported;
            this.trailing = trailing;
            this.importType = importType;
        }

        String imported() {
            return this.imported;
        }

        ImportType importType() {
            return this.importType;
        }

        String topLevel() {
            return (String)DOT_SPLITTER.split((CharSequence)this.imported()).iterator().next();
        }

        boolean isAndroid() {
            return Stream.of("android.", "androidx.", "dalvik.", "libcore.", "com.android.").anyMatch(this.imported::startsWith);
        }

        boolean isJava() {
            return switch (this.topLevel()) {
                case "java", "javax" -> true;
                default -> false;
            };
        }

        String trailing() {
            return this.trailing;
        }

        public boolean isThirdParty() {
            return !this.isAndroid() && !this.isJava();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("import ");
            switch (this.importType.ordinal()) {
                case 0: {
                    sb.append("static ");
                    break;
                }
                case 1: {
                    sb.append("module ");
                    break;
                }
            }
            sb.append(this.imported()).append(';');
            if (this.trailing().trim().isEmpty()) {
                sb.append(ImportOrderer.this.lineSeparator);
            } else {
                sb.append(this.trailing());
            }
            return sb.toString();
        }
    }

    static enum ImportType {
        STATIC,
        MODULE,
        NORMAL;

    }

    private static class StringAndIndex {
        private final String string;
        private final int index;

        StringAndIndex(String string, int index) {
            this.string = string;
            this.index = index;
        }
    }
}

