/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.ldap.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ldaptive.Connection;
import org.ldaptive.LdapAttribute;
import org.opensearch.common.settings.Settings;
import org.opensearch.secure_sm.AccessController;

public final class Utils {
    private static final Logger log = LogManager.getLogger(Utils.class);

    private Utils() {
    }

    public static void unbindAndCloseSilently(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            AccessController.doPrivilegedChecked(() -> connection.close());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<Map.Entry<String, Settings>> getOrderedBaseSettings(Settings settings) {
        return Utils.getOrderedBaseSettings(settings.getAsGroups());
    }

    public static List<Map.Entry<String, Settings>> getOrderedBaseSettings(Map<String, Settings> settingsMap) {
        return Utils.getOrderedBaseSettings(settingsMap.entrySet());
    }

    public static List<Map.Entry<String, Settings>> getOrderedBaseSettings(Set<Map.Entry<String, Settings>> set) {
        ArrayList<Map.Entry<String, Settings>> result = new ArrayList<Map.Entry<String, Settings>>(set);
        Utils.sortBaseSettings(result);
        return Collections.unmodifiableList(result);
    }

    private static void sortBaseSettings(List<Map.Entry<String, Settings>> list) {
        list.sort(new Comparator<Map.Entry<String, Settings>>(){

            @Override
            public int compare(Map.Entry<String, Settings> o1, Map.Entry<String, Settings> o2) {
                int attributeOrder = Integer.compare(o1.getValue().getAsInt("order", Integer.valueOf(Integer.MAX_VALUE)), o2.getValue().getAsInt("order", Integer.valueOf(Integer.MAX_VALUE)));
                if (attributeOrder != 0) {
                    return attributeOrder;
                }
                return o1.getKey().compareTo(o2.getKey());
            }
        });
    }

    public static String getSingleStringValue(LdapAttribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.size() > 1 && log.isDebugEnabled()) {
            log.debug("Multiple values found for {} ({})", (Object)attribute.getName(), (Object)attribute);
        }
        return attribute.getStringValue();
    }
}

