/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.action.whoami;

import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.security.action.whoami.WhoAmIRequest;
import org.opensearch.security.action.whoami.WhoAmIResponse;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.support.HeaderHelper;
import org.opensearch.security.user.User;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportWhoAmIAction
extends HandledTransportAction<WhoAmIRequest, WhoAmIResponse> {
    private final AdminDNs adminDNs;
    private final ThreadPool threadPool;

    @Inject
    public TransportWhoAmIAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, AdminDNs adminDNs, ActionFilters actionFilters) {
        super("cluster:admin/opendistro_security/whoami", transportService, actionFilters, WhoAmIRequest::new);
        this.adminDNs = adminDNs;
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, WhoAmIRequest request, ActionListener<WhoAmIResponse> listener) {
        User user = (User)this.threadPool.getThreadContext().getTransient("_opendistro_security_user");
        String dn = user == null ? (String)this.threadPool.getThreadContext().getTransient("_opendistro_security_ssl_transport_principal") : user.getName();
        boolean isAdmin = this.adminDNs.isAdminDN(dn);
        boolean isAuthenticated = isAdmin ? true : user != null;
        boolean isNodeCertificateRequest = HeaderHelper.isInterClusterRequest(this.threadPool.getThreadContext()) || HeaderHelper.isTrustedClusterRequest(this.threadPool.getThreadContext());
        listener.onResponse((Object)new WhoAmIResponse(dn, isAdmin, isAuthenticated, isNodeCertificateRequest));
    }
}

