/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.File;
import java.io.IOException;
import java.security.Security;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.nt.ExtendedSSLContext;
import oracle.net.nt.SSLConfig;
import oracle.net.nt.SSLContextCacheInfo;

class SSLContextCache {
    private static final String CLASS_NAME = SSLContextCache.class.getName();
    private static final SSLContextCache SINGLETON_INSTANCE = new SSLContextCache();
    private static final ConcurrentHashMap<SSLConfig, CacheEntry> CACHE_MAP = new ConcurrentHashMap();
    private static final Lock CACHE_LOCK = new ReentrantLock();
    private static final Set<String> CACHEABLE_KEYSTORE_TYPES = Stream.of("SSO", "PEM", "PKCS12", "JKS", "DATA_URI").collect(Collectors.toSet());
    private static int MAX_CACHE_SIZE = 15;
    static final boolean DISABLE_CACHE;

    private SSLContextCache() {
    }

    static SSLContextCache instance() {
        return SINGLETON_INSTANCE;
    }

    int cacheSize() {
        return CACHE_MAP.size();
    }

    void reset() {
        CACHE_LOCK.lock();
        CACHE_MAP.clear();
        CACHE_LOCK.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtendedSSLContext get(SSLConfig sslConfig, Diagnosable diagnosable) throws IOException {
        try {
            Diagnosable diagnosable2 = sslConfig.diagnosable = diagnosable == null ? CommonDiagnosable.getInstance() : diagnosable;
            if (DISABLE_CACHE || !this.cacheable(sslConfig)) {
                diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "get", "Not Using Cache. Creating SSLContext for config = {0}", (String)null, null, (Object)sslConfig);
                ExtendedSSLContext extendedSSLContext = this.createSSLContext(sslConfig);
                return extendedSSLContext;
            }
            CacheEntry cacheEntry = CACHE_MAP.get(sslConfig);
            if (cacheEntry != null && cacheEntry.isValid()) {
                diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "get", "Got a valid entry in cache and returning it.", null, null);
                SSLContextCacheInfo.incrementCacheHit();
                ExtendedSSLContext extendedSSLContext = cacheEntry.context();
                return extendedSSLContext;
            }
            ExtendedSSLContext extendedSSLContext = this.createCacheEntry(sslConfig).context();
            return extendedSSLContext;
        }
        finally {
            sslConfig.diagnosable = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry createCacheEntry(SSLConfig config) throws IOException {
        CACHE_LOCK.lock();
        try {
            CacheEntry entry = CACHE_MAP.get(config);
            if (entry != null) {
                if (entry.isValid()) {
                    config.diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "createCacheEntry", "Found a valid entry in cache and returning it.", null, null);
                    SSLContextCacheInfo.incrementCacheHit();
                    CacheEntry cacheEntry = entry;
                    return cacheEntry;
                }
                config.diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "createCacheEntry", "Removing invalid entry for config = {0}", (String)null, null, (Object)config);
                this.removeEntry(config);
            }
            config.diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "createCacheEntry", "No entry in cache, creating new one.", null, null);
            ExtendedSSLContext context = this.createSSLContext(config);
            SSLContextCacheInfo.incrementCacheMiss();
            if (CACHE_MAP.size() >= MAX_CACHE_SIZE) {
                this.removeLRUEntry(config.diagnosable);
            }
            CacheEntry newEntry = new CacheEntry(context, config);
            CACHE_MAP.put(config, newEntry);
            CacheEntry cacheEntry = newEntry;
            return cacheEntry;
        }
        finally {
            CACHE_LOCK.unlock();
        }
    }

    private void removeLRUEntry(Diagnosable diagnosable) {
        Enumeration<SSLConfig> keys = CACHE_MAP.keys();
        long usedTime = Long.MAX_VALUE;
        SSLConfig configToBeRemoved = null;
        while (keys.hasMoreElements()) {
            SSLConfig config = keys.nextElement();
            CacheEntry cacheEntry = CACHE_MAP.get(config);
            if (cacheEntry.lastUsed() >= usedTime) continue;
            configToBeRemoved = config;
            usedTime = cacheEntry.lastUsed();
        }
        if (configToBeRemoved != null) {
            diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "removeLRUEntry", "Reached cache max size. Removing the least recently used entry = {0}", (String)null, null, (Object)configToBeRemoved);
            this.removeEntry(configToBeRemoved);
        }
    }

    private ExtendedSSLContext createSSLContext(SSLConfig config) throws IOException {
        return CustomSSLSocketFactory.getSSLContext(config, config.diagnosable);
    }

    private boolean cacheable(SSLConfig config) {
        return this.isCachebleKeyStoreType(config.getKeyStoreType()) || this.isCachebleKeyStoreType(config.getTrustStoreType());
    }

    private boolean isCachebleKeyStoreType(String type) {
        if (type == null || type.isEmpty()) {
            return false;
        }
        return CACHEABLE_KEYSTORE_TYPES.contains(type);
    }

    private void removeEntry(SSLConfig config) {
        if (CACHE_MAP.remove(config) != null) {
            SSLContextCacheInfo.incrementCacheRemove();
        }
    }

    static {
        try {
            MAX_CACHE_SIZE = Integer.parseInt(System.getProperty("oracle.net.sslContextCacheSize", "15"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        DISABLE_CACHE = MAX_CACHE_SIZE <= 0;
    }

    private static class CacheEntry {
        private final ExtendedSSLContext extendedSSLContext;
        private final SSLConfig config;
        private long lastUsed;
        private final String[] cachedFiles;
        private final Long[] cachedFileModifiedTimes;

        CacheEntry(ExtendedSSLContext ectx, SSLConfig config) {
            this.extendedSSLContext = ectx;
            this.config = config;
            this.cachedFiles = this.cachedFiles();
            this.cachedFileModifiedTimes = new Long[this.cachedFiles.length];
            for (int i = 0; i < this.cachedFiles.length; ++i) {
                this.cachedFileModifiedTimes[i] = new File(this.cachedFiles[i]).lastModified();
            }
            this.lastUsed = System.currentTimeMillis();
        }

        boolean isValid() {
            for (int i = 0; i < this.cachedFiles.length; ++i) {
                if (!this.isKeyStoreModified(this.cachedFiles[i], this.cachedFileModifiedTimes[i])) continue;
                CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "isValid", "Invalid entry, Keystore file {0} updated or removed.", (String)null, null, (Object)this.cachedFiles[i]);
                return false;
            }
            return !this.isProviderRemoved(this.extendedSSLContext.getKeyStoreProvider()) && !this.isProviderRemoved(this.extendedSSLContext.getTrustStoreProvider());
        }

        ExtendedSSLContext context() {
            this.lastUsed = System.currentTimeMillis();
            return this.extendedSSLContext;
        }

        long lastUsed() {
            return this.lastUsed;
        }

        private String[] cachedFiles() {
            if (this.config.isWallet()) {
                String[] stringArray;
                if (this.config.getKeyStore() == null || SSLConfig.isDataUri(this.config.getKeyStore())) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = this.config.getKeyStore();
                }
                return stringArray;
            }
            LinkedList<String> files = new LinkedList<String>();
            if (this.config.getKeyStore() != null) {
                files.add(this.config.getKeyStore());
            }
            if (this.config.getTrustStore() != null) {
                files.add(this.config.getTrustStore());
            }
            return files.toArray(new String[files.size()]);
        }

        private boolean isKeyStoreModified(String filePath, long creationTime) {
            File ksFile = new File(filePath);
            if (!ksFile.exists()) {
                return true;
            }
            return ksFile.lastModified() > creationTime;
        }

        private boolean isProviderRemoved(String provider) {
            if (provider != null && Security.getProvider(provider) == null) {
                CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "isProviderRemoved", "Provider {0} removed at runtime.", (String)null, null, (Object)provider);
                return true;
            }
            return false;
        }
    }
}

