/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.dev.AlwaysFalsePredicate;
import io.quarkus.deployment.dev.DisableInstrumentationForClassPredicateBuildItem;
import io.quarkus.deployment.dev.DisableInstrumentationForIndexPredicateBuildItem;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ConfigureDisableInstrumentationBuildStep {
    @BuildStep
    ServiceStartBuildItem configure(List<DisableInstrumentationForIndexPredicateBuildItem> forIndexItems, List<DisableInstrumentationForClassPredicateBuildItem> forClassItems) {
        if (forClassItems.isEmpty() && forIndexItems.isEmpty()) {
            return null;
        }
        RuntimeUpdatesProcessor processor = RuntimeUpdatesProcessor.INSTANCE;
        if (processor != null) {
            processor.setDisableInstrumentationForIndexPredicate(this.determineEffectivePredicate(forIndexItems)).setDisableInstrumentationForClassPredicate(this.determineEffectivePredicate(forClassItems));
        }
        return null;
    }

    private <T> Predicate<T> determineEffectivePredicate(List<? extends Supplier<Predicate<T>>> suppliers) {
        if (suppliers.isEmpty()) {
            return new AlwaysFalsePredicate();
        }
        if (suppliers.size() == 1) {
            return suppliers.get(0).get();
        }
        return suppliers.stream().map(Supplier::get).reduce(c -> false, Predicate::or);
    }
}

