/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.eclipse.debug.core.model.IBinaryStreamMonitor;
import org.eclipse.debug.core.model.IBinaryStreamsProxy;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.internal.core.InputStreamMonitor;
import org.eclipse.debug.internal.core.OutputStreamMonitor;

public class StreamsProxy
implements IBinaryStreamsProxy {
    private final OutputStreamMonitor fOutputMonitor;
    private final OutputStreamMonitor fErrorMonitor;
    private final InputStreamMonitor fInputMonitor;
    private boolean fClosed;
    private boolean started;

    public StreamsProxy(Process process, Charset charset, String suffix) {
        this(process, charset);
        this.startMonitoring(suffix);
    }

    public StreamsProxy(Process process, Charset charset) {
        if (process == null) {
            this.fOutputMonitor = new OutputStreamMonitor(InputStream.nullInputStream(), charset);
            this.fErrorMonitor = new OutputStreamMonitor(InputStream.nullInputStream(), charset);
            this.fInputMonitor = new InputStreamMonitor(OutputStream.nullOutputStream(), charset);
        } else {
            this.fOutputMonitor = new OutputStreamMonitor(process.getInputStream(), charset);
            this.fErrorMonitor = new OutputStreamMonitor(process.getErrorStream(), charset);
            this.fInputMonitor = new InputStreamMonitor(process.getOutputStream(), charset);
        }
    }

    public void startMonitoring(String suffix) {
        this.start();
        this.fOutputMonitor.startMonitoring("Output Stream Monitor" + suffix);
        this.fErrorMonitor.startMonitoring("Error Stream Monitor" + suffix);
        this.fInputMonitor.startMonitoring("Input Stream Monitor" + suffix);
    }

    private synchronized void start() {
        if (this.started) {
            throw new IllegalStateException("Already started!");
        }
        this.started = true;
    }

    @Deprecated(forRemoval=true, since="2025-06")
    public StreamsProxy(Process process, String encoding) {
        this(process, Charset.forName(encoding), "");
    }

    public void close() {
        if (!this.isClosed(true)) {
            this.fOutputMonitor.close();
            this.fErrorMonitor.close();
            this.fInputMonitor.close();
        }
    }

    private synchronized boolean isClosed(boolean setClosed) {
        boolean closed = this.fClosed;
        if (setClosed) {
            this.fClosed = true;
        }
        return closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        StreamsProxy streamsProxy = this;
        synchronized (streamsProxy) {
            this.fClosed = true;
        }
        this.fOutputMonitor.kill();
        this.fErrorMonitor.kill();
        this.fInputMonitor.close();
    }

    @Override
    public IStreamMonitor getErrorStreamMonitor() {
        return this.fErrorMonitor;
    }

    @Override
    public IStreamMonitor getOutputStreamMonitor() {
        return this.fOutputMonitor;
    }

    @Override
    public void write(String input) throws IOException {
        if (this.isClosed(false)) {
            throw new IOException();
        }
        this.fInputMonitor.write(input);
    }

    @Override
    public void closeInputStream() throws IOException {
        if (this.isClosed(false)) {
            throw new IOException();
        }
        this.fInputMonitor.closeInputStream();
    }

    @Override
    public IBinaryStreamMonitor getBinaryErrorStreamMonitor() {
        return this.fErrorMonitor;
    }

    @Override
    public IBinaryStreamMonitor getBinaryOutputStreamMonitor() {
        return this.fOutputMonitor;
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.isClosed(false)) {
            throw new IOException();
        }
        this.fInputMonitor.write(data, offset, length);
    }
}

