﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace PinpointSMSVoiceV2 {
namespace Model {

/**
 * <p>Provides the reason a registration was rejected.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/RegistrationDeniedReasonInformation">AWS
 * API Reference</a></p>
 */
class RegistrationDeniedReasonInformation {
 public:
  AWS_PINPOINTSMSVOICEV2_API RegistrationDeniedReasonInformation() = default;
  AWS_PINPOINTSMSVOICEV2_API RegistrationDeniedReasonInformation(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINTSMSVOICEV2_API RegistrationDeniedReasonInformation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINTSMSVOICEV2_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The reason a registration was rejected.</p>
   */
  inline const Aws::String& GetReason() const { return m_reason; }
  inline bool ReasonHasBeenSet() const { return m_reasonHasBeenSet; }
  template <typename ReasonT = Aws::String>
  void SetReason(ReasonT&& value) {
    m_reasonHasBeenSet = true;
    m_reason = std::forward<ReasonT>(value);
  }
  template <typename ReasonT = Aws::String>
  RegistrationDeniedReasonInformation& WithReason(ReasonT&& value) {
    SetReason(std::forward<ReasonT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A short description of the rejection reason.</p>
   */
  inline const Aws::String& GetShortDescription() const { return m_shortDescription; }
  inline bool ShortDescriptionHasBeenSet() const { return m_shortDescriptionHasBeenSet; }
  template <typename ShortDescriptionT = Aws::String>
  void SetShortDescription(ShortDescriptionT&& value) {
    m_shortDescriptionHasBeenSet = true;
    m_shortDescription = std::forward<ShortDescriptionT>(value);
  }
  template <typename ShortDescriptionT = Aws::String>
  RegistrationDeniedReasonInformation& WithShortDescription(ShortDescriptionT&& value) {
    SetShortDescription(std::forward<ShortDescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A long description of the rejection reason.</p>
   */
  inline const Aws::String& GetLongDescription() const { return m_longDescription; }
  inline bool LongDescriptionHasBeenSet() const { return m_longDescriptionHasBeenSet; }
  template <typename LongDescriptionT = Aws::String>
  void SetLongDescription(LongDescriptionT&& value) {
    m_longDescriptionHasBeenSet = true;
    m_longDescription = std::forward<LongDescriptionT>(value);
  }
  template <typename LongDescriptionT = Aws::String>
  RegistrationDeniedReasonInformation& WithLongDescription(LongDescriptionT&& value) {
    SetLongDescription(std::forward<LongDescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The title of the document.</p>
   */
  inline const Aws::String& GetDocumentationTitle() const { return m_documentationTitle; }
  inline bool DocumentationTitleHasBeenSet() const { return m_documentationTitleHasBeenSet; }
  template <typename DocumentationTitleT = Aws::String>
  void SetDocumentationTitle(DocumentationTitleT&& value) {
    m_documentationTitleHasBeenSet = true;
    m_documentationTitle = std::forward<DocumentationTitleT>(value);
  }
  template <typename DocumentationTitleT = Aws::String>
  RegistrationDeniedReasonInformation& WithDocumentationTitle(DocumentationTitleT&& value) {
    SetDocumentationTitle(std::forward<DocumentationTitleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The link to the document.</p>
   */
  inline const Aws::String& GetDocumentationLink() const { return m_documentationLink; }
  inline bool DocumentationLinkHasBeenSet() const { return m_documentationLinkHasBeenSet; }
  template <typename DocumentationLinkT = Aws::String>
  void SetDocumentationLink(DocumentationLinkT&& value) {
    m_documentationLinkHasBeenSet = true;
    m_documentationLink = std::forward<DocumentationLinkT>(value);
  }
  template <typename DocumentationLinkT = Aws::String>
  RegistrationDeniedReasonInformation& WithDocumentationLink(DocumentationLinkT&& value) {
    SetDocumentationLink(std::forward<DocumentationLinkT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_reason;

  Aws::String m_shortDescription;

  Aws::String m_longDescription;

  Aws::String m_documentationTitle;

  Aws::String m_documentationLink;
  bool m_reasonHasBeenSet = false;
  bool m_shortDescriptionHasBeenSet = false;
  bool m_longDescriptionHasBeenSet = false;
  bool m_documentationTitleHasBeenSet = false;
  bool m_documentationLinkHasBeenSet = false;
};

}  // namespace Model
}  // namespace PinpointSMSVoiceV2
}  // namespace Aws
