#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
module: devices_appliance_performance_info
short_description: Information module for devices _appliance _performance
description:
  - Information module for Devices Appliance Performance Info.
  - Get all devices _appliance _performance.
  - >
    Return the performance score for a single MX. Only primary MX devices supported.
    If no data is available, a 204 error code is returned.
version_added: '1.0.0'
extends_documentation_fragment:
  - cisco.meraki.module_info
author: Francisco Munoz (@fmunoz)
options:
  headers:
    description: Additional headers.
    type: dict
  serial:
    description:
      - Information module for Devices Appliance Performance Info.
      - Serial path parameter.
    type: str
  t0:
    description:
      - Information module for Devices Appliance Performance Info.
      - T0 query parameter. The beginning of the timespan for the data. The maximum
        lookback period is 30 days from today.
    type: str
  t1:
    description:
      - Information module for Devices Appliance Performance Info.
      - T1 query parameter. The end of the timespan for the data. T1 can be a maximum
        of 14 days after t0.
    type: str
  timespan:
    description:
      - Information module for Devices Appliance Performance Info.
      - >
        Timespan query parameter. The timespan for which the information will be fetched.
        If specifying timespan, do not specify parameters t0 and t1. The value must
        be in seconds and be greater than or equal to 30 minutes and be less than
        or equal to 14 days. The default is 30 minutes.
    type: float
requirements:
  - meraki >= 2.4.9
  - python >= 3.5
seealso:
  - name: Cisco Meraki documentation for appliance getDeviceAppliancePerformance
    description: Complete reference of the getDeviceAppliancePerformance API.
    link: https://developer.cisco.com/meraki/api-v1/#!get-device-appliance-performance
notes:
  - SDK Method used are
    appliance.Appliance.get_device_appliance_performance,
  - Paths used are
    get /devices/{serial}/appliance/performance,
"""

EXAMPLES = r"""
- name: Get all devices _appliance _performance
  cisco.meraki.devices_appliance_performance_info:
    meraki_api_key: "{{ meraki_api_key }}"
    meraki_base_url: "{{ meraki_base_url }}"
    meraki_single_request_timeout: "{{ meraki_single_request_timeout }}"
    meraki_certificate_path: "{{ meraki_certificate_path }}"
    meraki_requests_proxy: "{{ meraki_requests_proxy }}"
    meraki_wait_on_rate_limit: "{{ meraki_wait_on_rate_limit }}"
    meraki_nginx_429_retry_wait_time: "{{ meraki_nginx_429_retry_wait_time }}"
    meraki_action_batch_retry_wait_time: "{{ meraki_action_batch_retry_wait_time }}"
    meraki_retry_4xx_error: "{{ meraki_retry_4xx_error }}"
    meraki_retry_4xx_error_wait_time: "{{ meraki_retry_4xx_error_wait_time }}"
    meraki_maximum_retries: "{{ meraki_maximum_retries }}"
    meraki_output_log: "{{ meraki_output_log }}"
    meraki_log_file_prefix: "{{ meraki_log_file_prefix }}"
    meraki_log_path: "{{ meraki_log_path }}"
    meraki_print_console: "{{ meraki_print_console }}"
    meraki_suppress_logging: "{{ meraki_suppress_logging }}"
    meraki_simulate: "{{ meraki_simulate }}"
    meraki_be_geo_id: "{{ meraki_be_geo_id }}"
    meraki_caller: "{{ meraki_caller }}"
    meraki_use_iterator_for_get_pages: "{{ meraki_use_iterator_for_get_pages }}"
    meraki_inherit_logging_config: "{{ meraki_inherit_logging_config }}"
    t0: string
    t1: string
    timespan: 0
    serial: string
  register: result
"""
RETURN = r"""
meraki_response:
  description: A dictionary or list with the response returned by the Cisco Meraki Python SDK
  returned: always
  type: dict
  sample: >
    {
      "perfScore": 0
    }
"""
