/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.impl.ConfigurableImpl;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;

public class ConfigurationImpl
implements Configuration {
    private static final Logger LOG = LogUtils.getL7dLogger(ConfigurationImpl.class);
    private Map<String, Object> props = new HashMap<String, Object>();
    private RuntimeType runtimeType;
    private Map<Object, Map<Class<?>, Integer>> providers = new LinkedHashMap();
    private Map<Feature, Boolean> features = new LinkedHashMap<Feature, Boolean>();

    public ConfigurationImpl(RuntimeType rt) {
        this.runtimeType = rt;
    }

    public ConfigurationImpl(Configuration parent) {
        if (parent != null) {
            this.props.putAll(parent.getProperties());
            this.runtimeType = parent.getRuntimeType();
            HashSet providerClasses = new HashSet(parent.getClasses());
            for (Object o : parent.getInstances()) {
                if (!(o instanceof Feature)) {
                    this.registerParentProvider(o, parent);
                } else {
                    Feature f = (Feature)o;
                    this.features.put(f, parent.isEnabled(f));
                }
                providerClasses.remove(o.getClass());
            }
            for (Class cls : providerClasses) {
                this.registerParentProvider(ConfigurationImpl.createProvider(cls), parent);
            }
        }
    }

    private void registerParentProvider(Object o, Configuration parent) {
        Map contracts = parent.getContracts(o.getClass());
        if (contracts != null) {
            this.providers.put(o, contracts);
        } else {
            this.register(o, AnnotationUtils.getBindingPriority(o.getClass()), ConfigurableImpl.getImplementedContracts(o, new Class[0]));
        }
    }

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet();
        for (Object o : this.getInstances()) {
            classes.add(o.getClass());
        }
        return classes;
    }

    public Map<Class<?>, Integer> getContracts(Class<?> cls) {
        for (Object o : this.getInstances()) {
            if (!cls.isAssignableFrom(o.getClass())) continue;
            if (o instanceof Feature) {
                return Collections.emptyMap();
            }
            return this.providers.get(o);
        }
        return Collections.emptyMap();
    }

    public Set<Object> getInstances() {
        HashSet<Object> allInstances = new HashSet<Object>();
        allInstances.addAll(this.providers.keySet());
        allInstances.addAll(this.features.keySet());
        return Collections.unmodifiableSet(allInstances);
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.props);
    }

    public Object getProperty(String name) {
        return this.props.get(name);
    }

    public Collection<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.props.keySet());
    }

    public RuntimeType getRuntimeType() {
        return this.runtimeType;
    }

    public boolean isEnabled(Feature f) {
        return this.features.containsKey(f) && this.features.get(f) != false;
    }

    public boolean isEnabled(Class<? extends Feature> f) {
        for (Map.Entry<Feature, Boolean> entry : this.features.entrySet()) {
            Feature feature = entry.getKey();
            Boolean enabled = entry.getValue();
            if (!f.isAssignableFrom(feature.getClass()) || !enabled.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isRegistered(Object obj) {
        for (Object o : this.getInstances()) {
            if (!o.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public boolean isRegistered(Class<?> cls) {
        for (Object o : this.getInstances()) {
            if (cls != o.getClass()) continue;
            return true;
        }
        return false;
    }

    public void setProperty(String name, Object value) {
        if (name == null) {
            this.props.remove(name);
        } else {
            this.props.put(name, value);
        }
    }

    public void setFeature(Feature f, boolean enabled) {
        this.features.put(f, enabled);
    }

    private void register(Object provider, int bindingPriority, Class<?> ... contracts) {
        this.register(provider, ConfigurationImpl.initContractsMap(bindingPriority, contracts));
    }

    public boolean register(Object provider, Map<Class<?>, Integer> contracts) {
        if (provider.getClass() == Class.class) {
            if (this.isRegistered((Class)provider)) {
                LOG.warning("Provider class " + ((Class)provider).getName() + " has already been registered");
                return false;
            }
            provider = ConfigurationImpl.createProvider((Class)provider);
        }
        if (this.isRegistered(provider)) {
            LOG.warning("Provider " + provider.getClass().getName() + " has already been registered");
            return false;
        }
        if (!this.contractsValid(provider, contracts)) {
            return false;
        }
        Map<Class<?>, Integer> metadata = this.providers.get(provider);
        if (metadata == null) {
            metadata = new HashMap();
            this.providers.put(provider, metadata);
        }
        for (Map.Entry<Class<?>, Integer> entry : contracts.entrySet()) {
            if (!entry.getKey().isAssignableFrom(provider.getClass())) continue;
            metadata.put(entry.getKey(), entry.getValue());
        }
        return true;
    }

    private boolean contractsValid(Object provider, Map<Class<?>, Integer> contracts) {
        Class<?> providerClass = provider.getClass();
        for (Class<?> contractInterface : contracts.keySet()) {
            if (contractInterface.isAssignableFrom(providerClass)) continue;
            LOG.warning("Provider " + providerClass.getName() + " does not implement specified contract: " + contractInterface.getName());
            return false;
        }
        return true;
    }

    public static Map<Class<?>, Integer> initContractsMap(int bindingPriority, Class<?> ... contracts) {
        HashMap metadata = new HashMap();
        for (Class<?> contract : contracts) {
            metadata.put(contract, bindingPriority);
        }
        return metadata;
    }

    public static Object createProvider(Class<?> cls) {
        try {
            return cls.newInstance();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

