/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.features.shell;

import java.net.URI;
import java.util.Map;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.shell.CellarCommandSupport;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.cellar.features.ClusterRepositoryEvent;
import org.apache.karaf.cellar.features.FeatureState;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.RepositoryEvent;
import org.apache.karaf.features.command.completers.AvailableRepoNameCompleter;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="feature-repo-add", description="Add a features repository to a cluster group")
@Service
public class RepoAddCommand
extends CellarCommandSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;
    @Argument(index=1, name="name/url", description="Shortcut name of the features repository or the full URL", required=true, multiValued=false)
    @Completion(value=AvailableRepoNameCompleter.class)
    String nameOrUrl;
    @Argument(index=2, name="version", description="The version of the features repository if using features repository name as first argument. It should be empty if using the URL.", required=false, multiValued=false)
    String version;
    @Option(name="-i", aliases={"--install"}, description="Install all features contained in the features repository", required=false, multiValued=false)
    boolean install;
    @Reference
    private EventProducer eventProducer;
    @Reference
    private FeaturesService featuresService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            System.err.println("Cluster event producer is OFF");
            return null;
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            Map clusterRepositories = this.clusterManager.getMap("org.apache.karaf.cellar.repositories." + this.groupName);
            Map clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + this.groupName);
            URI uri = this.featuresService.getRepositoryUriFor(this.nameOrUrl, this.version);
            if (uri == null) {
                uri = new URI(this.nameOrUrl);
            }
            String name = null;
            for (Object repository : clusterRepositories.keySet()) {
                if (!((String)repository).equals(uri)) continue;
                name = (String)clusterRepositories.get(uri);
                break;
            }
            if (name == null) {
                Features repository = JaxbUtil.unmarshal(uri.toASCIIString(), true);
                clusterRepositories.put(uri.toString(), repository.getName());
                for (Feature feature : repository.getFeature()) {
                    FeatureState featureState = new FeatureState();
                    featureState.setName(feature.getName());
                    featureState.setVersion(feature.getVersion());
                    featureState.setInstalled(this.featuresService.isInstalled(feature));
                    clusterFeatures.put(feature.getName() + "/" + feature.getVersion(), featureState);
                }
                ClusterRepositoryEvent event = new ClusterRepositoryEvent(uri.toString(), RepositoryEvent.EventType.RepositoryAdded);
                event.setInstall(this.install);
                event.setSourceGroup(group);
                event.setSourceNode(this.clusterManager.getNode());
                this.eventProducer.produce((Event)event);
            } else {
                System.err.println("Features repository URL " + uri + " already registered");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }

    public EventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    public FeaturesService getFeaturesService() {
        return this.featuresService;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }
}

