/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.groovy.actions.listener;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.unomi.groovy.actions.services.GroovyActionsService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SynchronousBundleListener.class})
public class GroovyActionListener
implements SynchronousBundleListener {
    private static final Logger logger = LoggerFactory.getLogger((String)GroovyActionListener.class.getName());
    public static final String ENTRIES_LOCATION = "META-INF/cxs/actions";
    private GroovyActionsService groovyActionsService;
    private BundleContext bundleContext;

    @Reference
    public void setGroovyActionsService(GroovyActionsService groovyActionsService) {
        this.groovyActionsService = groovyActionsService;
    }

    @Activate
    public void postConstruct(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        logger.debug("postConstruct {}", (Object)bundleContext.getBundle());
        this.loadGroovyActions(bundleContext);
        for (Bundle bundle : bundleContext.getBundles()) {
            if (bundle.getBundleContext() == null || bundle.getBundleId() == bundleContext.getBundle().getBundleId()) continue;
            this.loadGroovyActions(bundle.getBundleContext());
        }
        bundleContext.addBundleListener((BundleListener)this);
        logger.info("Groovy Action Dispatcher initialized.");
    }

    @Deactivate
    public void preDestroy() {
        this.processBundleStop(this.bundleContext);
        this.bundleContext.removeBundleListener((BundleListener)this);
        logger.info("Groovy Action Dispatcher shutdown.");
    }

    private void processBundleStartup(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        this.loadGroovyActions(bundleContext);
    }

    private void processBundleStop(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        this.unloadGroovyActions(bundleContext);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.processBundleStartup(event.getBundle().getBundleContext());
                break;
            }
            case 256: {
                if (event.getBundle().getSymbolicName().equals("org.apache.unomi.groovy-actions-services")) break;
                this.processBundleStop(event.getBundle().getBundleContext());
            }
        }
    }

    private void addGroovyAction(URL groovyActionURL) {
        try {
            this.groovyActionsService.save(FilenameUtils.getName((String)groovyActionURL.getPath()).replace(".groovy", ""), IOUtils.toString((InputStream)groovyActionURL.openStream()));
        }
        catch (IOException e) {
            logger.error("Failed to load the groovy action {}", (Object)groovyActionURL.getPath(), (Object)e);
        }
    }

    private void removeGroovyAction(URL groovyActionURL) {
        String actionName = FilenameUtils.getName((String)groovyActionURL.getPath()).replace(".groovy", "");
        this.groovyActionsService.remove(actionName);
        logger.info("The script {} has been removed.", (Object)actionName);
    }

    private void loadGroovyActions(BundleContext bundleContext) {
        Enumeration bundleGroovyActions = bundleContext.getBundle().findEntries(ENTRIES_LOCATION, "*.groovy", true);
        if (bundleGroovyActions == null) {
            return;
        }
        while (bundleGroovyActions.hasMoreElements()) {
            URL groovyActionURL = (URL)bundleGroovyActions.nextElement();
            logger.debug("Found Groovy action at {}, loading... ", (Object)groovyActionURL.getPath());
            this.addGroovyAction(groovyActionURL);
        }
    }

    private void unloadGroovyActions(BundleContext bundleContext) {
        Enumeration bundleGroovyActions = bundleContext.getBundle().findEntries(ENTRIES_LOCATION, "*.groovy", true);
        if (bundleGroovyActions == null) {
            return;
        }
        while (bundleGroovyActions.hasMoreElements()) {
            URL groovyActionURL = (URL)bundleGroovyActions.nextElement();
            logger.debug("Found Groovy action at {}, loading... ", (Object)groovyActionURL.getPath());
            this.removeGroovyAction(groovyActionURL);
        }
    }
}

