/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.component;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.CasConsumer_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.resource.ResourceInitializationException;
import org.springframework.util.DigestUtils;

public class CasDumpWriter
extends CasConsumer_ImplBase {
    public static final String INCLUDE_PREFIX = "+|";
    public static final String EXCLUDE_PREFIX = "-|";
    public static final String PARAM_OUTPUT_FILE = "outputFile";
    @ConfigurationParameter(name="outputFile", mandatory=true, defaultValue={"-"})
    private File outputFile;
    public static final String PARAM_WRITE_DOCUMENT_META_DATA = "writeDocumentMetaData";
    @ConfigurationParameter(name="writeDocumentMetaData", mandatory=true, defaultValue={"true"})
    private boolean writeDocumentMetaData;
    public static final String PARAM_FEATURE_PATTERNS = "featurePatterns";
    @ConfigurationParameter(name="featurePatterns", mandatory=true, defaultValue={"+|.*", "-|^.*documentUri:.*$", "-|^.*collectionId:.*$", "-|^.*documentBaseUri:.*$"})
    private String[] featurePatterns;
    private InExPattern[] cookedFeaturePatterns;
    public static final String PARAM_TYPE_PATTERNS = "typePatterns";
    @ConfigurationParameter(name="typePatterns", mandatory=true, defaultValue={"+|.*"})
    private String[] typePatterns;
    public static final String PARAM_SORT = "sort";
    @ConfigurationParameter(name="sort", mandatory=true, defaultValue={"false"})
    private boolean sort;
    private InExPattern[] cookedTypePatterns;
    private PrintWriter out;
    private int iCas;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            if (this.out == null) {
                if ("-".equals(this.outputFile.getName())) {
                    this.out = new PrintWriter((OutputStream)new CloseShieldOutputStream((OutputStream)System.out));
                } else {
                    if (this.outputFile.getParentFile() != null) {
                        this.outputFile.getParentFile().mkdirs();
                    }
                    this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF-8"));
                }
            }
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.cookedTypePatterns = CasDumpWriter.compilePatterns(this.typePatterns);
        this.cookedFeaturePatterns = CasDumpWriter.compilePatterns(this.featurePatterns);
    }

    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        this.out.println("======== CAS " + this.iCas + " begin ==================================");
        this.out.println();
        Iterator viewIt = aCAS.getViewIterator();
        while (viewIt.hasNext()) {
            CAS view = (CAS)viewIt.next();
            this.processView(view);
            if (view.getDocumentText() != null || view.getSofaDataStream() == null) continue;
            this.processSofaData(view);
        }
        this.out.println("======== CAS " + this.iCas + " end ==================================");
        this.out.println();
        this.out.println();
        this.out.flush();
        ++this.iCas;
    }

    public void collectionProcessComplete() {
        IOUtils.closeQuietly((Writer)this.out);
        this.out = null;
    }

    private void processDocumentMetadata(CAS aCAS) {
        if (!this.writeDocumentMetaData) {
            return;
        }
        this.processFeatureStructure((FeatureStructure)aCAS.getDocumentAnnotation());
    }

    private void processDocumentText(CAS aCAS) {
        this.out.println();
        this.out.println("CAS-Text:");
        this.out.println(aCAS.getDocumentText());
    }

    private void processFeatureStructures(CAS aCAS) {
        Set<String> typesToPrint = this.getTypes(aCAS);
        Object annotationIterator = aCAS.getAnnotationIndex().iterator();
        if (this.sort) {
            ArrayList<AnnotationFS> sortedFS = new ArrayList<AnnotationFS>();
            while (annotationIterator.hasNext()) {
                sortedFS.add((AnnotationFS)annotationIterator.next());
            }
            Collections.sort(sortedFS, new Comparator<AnnotationFS>(){

                @Override
                public int compare(AnnotationFS aO1, AnnotationFS aO2) {
                    int begin = aO1.getBegin() - aO2.getBegin();
                    if (begin != 0) {
                        return begin;
                    }
                    int end = aO2.getEnd() - aO1.getEnd();
                    if (end != 0) {
                        return end;
                    }
                    int name = aO1.getType().getName().compareTo(aO2.getType().getName());
                    if (name != 0) {
                        return name;
                    }
                    if (aO1 instanceof FeatureStructureImpl && aO2 instanceof FeatureStructureImpl) {
                        return ((FeatureStructureImpl)aO1).getAddress() - ((FeatureStructureImpl)aO2).getAddress();
                    }
                    return name;
                }
            });
            annotationIterator = sortedFS.iterator();
        }
        while (annotationIterator.hasNext()) {
            AnnotationFS annotation = (AnnotationFS)annotationIterator.next();
            if (!typesToPrint.contains(annotation.getType().getName())) continue;
            try {
                this.out.println("[" + annotation.getCoveredText() + "]");
            }
            catch (IndexOutOfBoundsException e) {
                this.out.println("<OFFSETS OUT OF BOUNDS>");
            }
            this.processFeatureStructure((FeatureStructure)annotation);
        }
    }

    private void processFeatureStructure(FeatureStructure aFS) {
        String meta = aFS.toString();
        for (String line : meta.split("\n")) {
            boolean print = false;
            for (InExPattern p : this.cookedFeaturePatterns) {
                p.matchter.reset(line);
                if (!p.matchter.matches()) continue;
                print = p.includeInOutput;
            }
            if (!print) continue;
            this.out.println(line);
        }
    }

    private void processView(CAS aCAS) {
        this.out.println("-------- View " + aCAS.getViewName() + " begin ----------------------------------");
        this.out.println();
        this.processDocumentMetadata(aCAS);
        this.processDocumentText(aCAS);
        this.processFeatureStructures(aCAS);
        this.out.println("-------- View " + aCAS.getViewName() + " end ----------------------------------");
        this.out.println();
    }

    private void processSofaData(CAS aCAS) throws AnalysisEngineProcessException {
        this.out.println("Sofa data:");
        String mimeType = aCAS.getSofaMimeType();
        if (mimeType != null) {
            this.out.println("   mime type:\t" + mimeType);
        }
        byte[] bytes = null;
        InputStream in = null;
        try {
            in = aCAS.getSofaDataStream();
            bytes = IOUtils.toByteArray((InputStream)in);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        if (bytes != null) {
            this.out.println("   size:\t" + bytes.length + " byte(s)");
            String hash = DigestUtils.md5DigestAsHex((byte[])bytes);
            this.out.println("   hash value:\t" + hash);
        }
        this.out.println();
    }

    private static InExPattern[] compilePatterns(String[] aPatterns) {
        InExPattern[] patterns = new InExPattern[aPatterns.length];
        for (int i = 0; i < aPatterns.length; ++i) {
            patterns[i] = aPatterns[i].startsWith(INCLUDE_PREFIX) ? new InExPattern(aPatterns[i].substring(INCLUDE_PREFIX.length()), true) : (aPatterns[i].startsWith(EXCLUDE_PREFIX) ? new InExPattern(aPatterns[i].substring(EXCLUDE_PREFIX.length()), false) : new InExPattern(aPatterns[i], false));
        }
        return patterns;
    }

    private Set<String> getTypes(CAS cas) {
        HashSet<String> types = new HashSet<String>();
        Iterator typeIt = cas.getTypeSystem().getTypeIterator();
        block0: while (typeIt.hasNext()) {
            Type type = (Type)typeIt.next();
            if (type.getName().equals(cas.getDocumentAnnotation().getType().getName())) continue;
            for (InExPattern p : this.cookedTypePatterns) {
                p.matchter.reset(type.getName());
                if (!p.matchter.matches()) continue;
                if (p.includeInOutput) {
                    types.add(type.getName());
                    continue block0;
                }
                types.remove(type.getName());
                continue block0;
            }
        }
        return types;
    }

    private static class InExPattern {
        final boolean includeInOutput;
        final Matcher matchter;

        public InExPattern(String aPattern, boolean aInclude) {
            this.includeInOutput = aInclude;
            this.matchter = Pattern.compile(aPattern).matcher("");
        }
    }
}

