/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque.om;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Transaction;
import org.apache.turbine.services.security.torque.om.TurbinePermission;
import org.apache.turbine.services.security.torque.om.TurbinePermissionPeer;
import org.apache.turbine.services.security.torque.om.TurbineRole;
import org.apache.turbine.services.security.torque.om.TurbineRolePeer;
import org.apache.turbine.services.security.torque.om.TurbineRolePermission;
import org.apache.turbine.services.security.torque.om.TurbineRolePermissionPeer;

public abstract class BaseTurbineRolePermission
extends BaseObject {
    private static final long serialVersionUID = 1225810431540L;
    private static final TurbineRolePermissionPeer peer = new TurbineRolePermissionPeer();
    private int roleId;
    private int permissionId;
    private TurbineRole aTurbineRole;
    private TurbinePermission aTurbinePermission;
    private static List fieldNames = null;
    private boolean alreadyInSave = false;
    private final SimpleKey[] pks = new SimpleKey[2];
    private final ComboKey comboPK = new ComboKey(this.pks);

    public int getRoleId() {
        return this.roleId;
    }

    public void setRoleId(int v) throws TorqueException {
        if (this.roleId != v) {
            this.roleId = v;
            this.setModified(true);
        }
        if (this.aTurbineRole != null && this.aTurbineRole.getRoleId() != v) {
            this.aTurbineRole = null;
        }
    }

    public int getPermissionId() {
        return this.permissionId;
    }

    public void setPermissionId(int v) throws TorqueException {
        if (this.permissionId != v) {
            this.permissionId = v;
            this.setModified(true);
        }
        if (this.aTurbinePermission != null && this.aTurbinePermission.getPermissionId() != v) {
            this.aTurbinePermission = null;
        }
    }

    public void setTurbineRole(TurbineRole v) throws TorqueException {
        if (v == null) {
            this.setRoleId(0);
        } else {
            this.setRoleId(v.getRoleId());
        }
        this.aTurbineRole = v;
    }

    public TurbineRole getTurbineRole() throws TorqueException {
        if (this.aTurbineRole == null && this.roleId != 0) {
            this.aTurbineRole = TurbineRolePeer.retrieveByPK((ObjectKey)SimpleKey.keyFor((int)this.roleId));
        }
        return this.aTurbineRole;
    }

    public TurbineRole getTurbineRole(Connection connection) throws TorqueException {
        if (this.aTurbineRole == null && this.roleId != 0) {
            this.aTurbineRole = TurbineRolePeer.retrieveByPK((ObjectKey)SimpleKey.keyFor((int)this.roleId), connection);
        }
        return this.aTurbineRole;
    }

    public void setTurbineRoleKey(ObjectKey key) throws TorqueException {
        this.setRoleId(((NumberKey)key).intValue());
    }

    public void setTurbinePermission(TurbinePermission v) throws TorqueException {
        if (v == null) {
            this.setPermissionId(0);
        } else {
            this.setPermissionId(v.getPermissionId());
        }
        this.aTurbinePermission = v;
    }

    public TurbinePermission getTurbinePermission() throws TorqueException {
        if (this.aTurbinePermission == null && this.permissionId != 0) {
            this.aTurbinePermission = TurbinePermissionPeer.retrieveByPK((ObjectKey)SimpleKey.keyFor((int)this.permissionId));
        }
        return this.aTurbinePermission;
    }

    public TurbinePermission getTurbinePermission(Connection connection) throws TorqueException {
        if (this.aTurbinePermission == null && this.permissionId != 0) {
            this.aTurbinePermission = TurbinePermissionPeer.retrieveByPK((ObjectKey)SimpleKey.keyFor((int)this.permissionId), connection);
        }
        return this.aTurbinePermission;
    }

    public void setTurbinePermissionKey(ObjectKey key) throws TorqueException {
        this.setPermissionId(((NumberKey)key).intValue());
    }

    public static synchronized List getFieldNames() {
        if (fieldNames == null) {
            fieldNames = new ArrayList();
            fieldNames.add("RoleId");
            fieldNames.add("PermissionId");
            fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    public Object getByName(String name) {
        if (name.equals("RoleId")) {
            return new Integer(this.getRoleId());
        }
        if (name.equals("PermissionId")) {
            return new Integer(this.getPermissionId());
        }
        return null;
    }

    public boolean setByName(String name, Object value) throws TorqueException, IllegalArgumentException {
        if (name.equals("RoleId")) {
            if (value == null || !Integer.class.isInstance(value)) {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            this.setRoleId((Integer)value);
            return true;
        }
        if (name.equals("PermissionId")) {
            if (value == null || !Integer.class.isInstance(value)) {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            this.setPermissionId((Integer)value);
            return true;
        }
        return false;
    }

    public Object getByPeerName(String name) {
        if (name.equals(TurbineRolePermissionPeer.ROLE_ID)) {
            return new Integer(this.getRoleId());
        }
        if (name.equals(TurbineRolePermissionPeer.PERMISSION_ID)) {
            return new Integer(this.getPermissionId());
        }
        return null;
    }

    public boolean setByPeerName(String name, Object value) throws TorqueException, IllegalArgumentException {
        if (TurbineRolePermissionPeer.ROLE_ID.equals(name)) {
            return this.setByName("RoleId", value);
        }
        if (TurbineRolePermissionPeer.PERMISSION_ID.equals(name)) {
            return this.setByName("PermissionId", value);
        }
        return false;
    }

    public Object getByPosition(int pos) {
        if (pos == 0) {
            return new Integer(this.getRoleId());
        }
        if (pos == 1) {
            return new Integer(this.getPermissionId());
        }
        return null;
    }

    public boolean setByPosition(int position, Object value) throws TorqueException, IllegalArgumentException {
        if (position == 0) {
            return this.setByName("RoleId", value);
        }
        if (position == 1) {
            return this.setByName("PermissionId", value);
        }
        return false;
    }

    public void save() throws Exception {
        this.save(TurbineRolePermissionPeer.DATABASE_NAME);
    }

    public void save(String dbName) throws TorqueException {
        Connection con = null;
        try {
            con = Transaction.begin((String)dbName);
            this.save(con);
            Transaction.commit((Connection)con);
        }
        catch (TorqueException e) {
            Transaction.safeRollback((Connection)con);
            throw e;
        }
    }

    public void save(Connection con) throws TorqueException {
        if (!this.alreadyInSave) {
            this.alreadyInSave = true;
            if (this.isModified()) {
                if (this.isNew()) {
                    TurbineRolePermissionPeer.doInsert((TurbineRolePermission)this, con);
                    this.setNew(false);
                } else {
                    TurbineRolePermissionPeer.doUpdate((TurbineRolePermission)this, con);
                }
            }
            this.alreadyInSave = false;
        }
    }

    public void setPrimaryKey(ObjectKey key) throws TorqueException {
        SimpleKey[] keys = (SimpleKey[])key.getValue();
        this.setRoleId(((NumberKey)keys[0]).intValue());
        this.setPermissionId(((NumberKey)keys[1]).intValue());
    }

    public void setPrimaryKey(int roleId, int permissionId) throws TorqueException {
        this.setRoleId(roleId);
        this.setPermissionId(permissionId);
    }

    public void setPrimaryKey(String key) throws TorqueException {
        this.setPrimaryKey((ObjectKey)new ComboKey(key));
    }

    public ObjectKey getPrimaryKey() {
        this.pks[0] = SimpleKey.keyFor((int)this.getRoleId());
        this.pks[1] = SimpleKey.keyFor((int)this.getPermissionId());
        return this.comboPK;
    }

    public TurbineRolePermission copy() throws TorqueException {
        return this.copy(true);
    }

    public TurbineRolePermission copy(Connection con) throws TorqueException {
        return this.copy(true, con);
    }

    public TurbineRolePermission copy(boolean deepcopy) throws TorqueException {
        return this.copyInto(new TurbineRolePermission(), deepcopy);
    }

    public TurbineRolePermission copy(boolean deepcopy, Connection con) throws TorqueException {
        return this.copyInto(new TurbineRolePermission(), deepcopy, con);
    }

    protected TurbineRolePermission copyInto(TurbineRolePermission copyObj) throws TorqueException {
        return this.copyInto(copyObj, true);
    }

    protected TurbineRolePermission copyInto(TurbineRolePermission copyObj, Connection con) throws TorqueException {
        return this.copyInto(copyObj, true, con);
    }

    protected TurbineRolePermission copyInto(TurbineRolePermission copyObj, boolean deepcopy) throws TorqueException {
        copyObj.setRoleId(this.roleId);
        copyObj.setPermissionId(this.permissionId);
        copyObj.setRoleId(0);
        copyObj.setPermissionId(0);
        if (deepcopy) {
            // empty if block
        }
        return copyObj;
    }

    protected TurbineRolePermission copyInto(TurbineRolePermission copyObj, boolean deepcopy, Connection con) throws TorqueException {
        copyObj.setRoleId(this.roleId);
        copyObj.setPermissionId(this.permissionId);
        copyObj.setRoleId(0);
        copyObj.setPermissionId(0);
        if (deepcopy) {
            // empty if block
        }
        return copyObj;
    }

    public TurbineRolePermissionPeer getPeer() {
        return peer;
    }

    public TableMap getTableMap() throws TorqueException {
        return TurbineRolePermissionPeer.getTableMap();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("TurbineRolePermission:\n");
        str.append("RoleId = ").append(this.getRoleId()).append("\n");
        str.append("PermissionId = ").append(this.getPermissionId()).append("\n");
        return str.toString();
    }
}

