/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.avaloncomponent;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.Log4JLoggerManager;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.avaloncomponent.AvalonComponentService;

public class TurbineAvalonComponentService
extends TurbineBaseService
implements AvalonComponentService,
Initializable,
Disposable {
    private static Log log = LogFactory.getLog((Class)TurbineAvalonComponentService.class);
    private ExcaliburComponentManager manager = null;

    public void init() throws InitializationException {
        try {
            this.initialize();
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("init failed", e);
        }
    }

    public void shutdown() {
        this.dispose();
        this.setInit(false);
    }

    public void initialize() throws Exception {
        org.apache.commons.configuration.Configuration conf = this.getConfiguration();
        String sysConfigFilename = Turbine.getRealPath(conf.getString("componentConfiguration", "/WEB-INF/conf/componentConfiguration.xml"));
        String roleConfigFilename = Turbine.getRealPath(conf.getString("componentRoles", "/WEB-INF/conf/roleConfiguration.xml"));
        log.debug((Object)("Config File: " + sysConfigFilename));
        log.debug((Object)("Role File:   " + roleConfigFilename));
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        Configuration sysConfig = builder.buildFromFile(sysConfigFilename);
        Configuration roleConfig = builder.buildFromFile(roleConfigFilename);
        Log4JLoggerManager lm = new Log4JLoggerManager();
        DefaultRoleManager roles = new DefaultRoleManager();
        Logger logger = lm.getLoggerForCategory("avalon");
        roles.enableLogging(logger);
        roles.configure(roleConfig);
        this.manager = new ExcaliburComponentManager();
        this.manager.setLoggerManager((LoggerManager)lm);
        this.manager.enableLogging(logger);
        DefaultContext context = new DefaultContext();
        String realPath = Turbine.getRealPath("/");
        context.put((Object)"componentAppRoot", (Object)realPath);
        System.setProperty("applicationRoot", realPath);
        log.debug((Object)("Application Root is " + realPath));
        this.manager.contextualize((Context)context);
        this.manager.setRoleManager((RoleManager)roles);
        this.manager.configure(sysConfig);
        this.manager.initialize();
        List lookupComponents = conf.getList("lookup", new Vector());
        Iterator it = lookupComponents.iterator();
        while (it.hasNext()) {
            String component = (String)it.next();
            try {
                Component c = this.manager.lookup(component);
                log.info((Object)("Lookup for Component " + component + " successful"));
                this.manager.release(c);
            }
            catch (Exception e) {
                log.error((Object)("Lookup for Component " + component + " failed!"));
            }
        }
    }

    public void dispose() {
        this.manager.dispose();
    }

    public Component lookup(String roleName) throws ComponentException {
        return this.manager.lookup(roleName);
    }

    public void release(Component component) {
        this.manager.release(component);
    }
}

