/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.tls.impl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.net.ssl.X509KeyManager;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;

public class StaticX509CredentialKeyManager
implements X509KeyManager {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(StaticX509CredentialKeyManager.class);
    @Nonnull
    private PrivateKey privateKey;
    @Nonnull
    private X509Certificate[] certificateChain;
    @Nonnull
    private String internalAlias = "internalAlias-" + this.toString();

    public StaticX509CredentialKeyManager(X509Credential credential) {
        Constraint.isNotNull((Object)credential, (String)"Credential may not be null");
        this.privateKey = (PrivateKey)Constraint.isNotNull((Object)credential.getPrivateKey(), (String)"Credential PrivateKey may not be null");
        this.certificateChain = ((Collection)Constraint.isNotNull((Object)credential.getEntityCertificateChain(), (String)"Credential certificate chain may not be null")).toArray(new X509Certificate[0]);
        this.log.trace("Generated static internal alias was: {}", (Object)this.internalAlias);
    }

    public StaticX509CredentialKeyManager(PrivateKey key, Collection<X509Certificate> chain) {
        this.privateKey = (PrivateKey)Constraint.isNotNull((Object)key, (String)"PrivateKey may not be null");
        this.certificateChain = ((Collection)Constraint.isNotNull(chain, (String)"Certificate chain may not be null")).toArray(new X509Certificate[0]);
        this.log.trace("Generated static internal alias was: {}", (Object)this.internalAlias);
    }

    @Override
    public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
        this.log.trace("In chooseClientAlias");
        return this.internalAlias;
    }

    @Override
    public String[] getClientAliases(String arg0, Principal[] arg1) {
        this.log.trace("In getClientAliases");
        return new String[]{this.internalAlias};
    }

    @Override
    public X509Certificate[] getCertificateChain(String arg0) {
        this.log.trace("In getCertificateChain");
        return this.internalAlias.equals(arg0) ? this.certificateChain : null;
    }

    @Override
    public PrivateKey getPrivateKey(String arg0) {
        this.log.trace("In getPrivateKey");
        return this.internalAlias.equals(arg0) ? this.privateKey : null;
    }

    @Override
    public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
        this.log.trace("In chooseServerAlias");
        return this.internalAlias;
    }

    @Override
    public String[] getServerAliases(String arg0, Principal[] arg1) {
        this.log.trace("In getServerAliases");
        return new String[]{this.internalAlias};
    }
}

