/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import java.util.Arrays;
import java.util.List;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.OAuthConnectionImpl;
import org.apache.sling.auth.oauth_client.impl.OidcConnectionImpl;
import org.apache.sling.auth.oauth_client.impl.ResolvedConnection;
import org.jetbrains.annotations.NotNull;

class ResolvedOAuthConnection
extends ResolvedConnection {
    private ResolvedOAuthConnection(@NotNull String name, String authorizationEndpoint, String tokenEndpoint, String clientId, String clientSecret, @NotNull List<String> scopes, @NotNull List<String> additionalAuthorizationParameters) {
        super(name, authorizationEndpoint, tokenEndpoint, clientId, clientSecret, scopes, additionalAuthorizationParameters);
    }

    @NotNull
    static ResolvedConnection resolve(@NotNull ClientConnection connection) {
        if (connection instanceof OidcConnectionImpl) {
            OidcConnectionImpl oidcConnection = (OidcConnectionImpl)connection;
            return new ResolvedOAuthConnection(connection.name(), oidcConnection.authorizationEndpoint(), oidcConnection.tokenEndpoint(), oidcConnection.clientId(), oidcConnection.clientSecret(), Arrays.asList(oidcConnection.scopes()), Arrays.asList(oidcConnection.additionalAuthorizationParameters()));
        }
        if (connection instanceof OAuthConnectionImpl) {
            OAuthConnectionImpl oauthConnection = (OAuthConnectionImpl)connection;
            return new ResolvedOAuthConnection(connection.name(), oauthConnection.authorizationEndpoint(), oauthConnection.tokenEndpoint(), oauthConnection.clientId(), oauthConnection.clientSecret(), Arrays.asList(oauthConnection.scopes()), Arrays.asList(oauthConnection.additionalAuthorizationParameters()));
        }
        throw new IllegalArgumentException(String.format("Unable to resolve %s (name=%s) of type %s", ClientConnection.class.getSimpleName(), connection.name(), connection.getClass().getName()));
    }
}

