/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.DerivedIterator;
import org.apache.sis.util.internal.shared.SetOfUnknownSize;
import org.apache.sis.util.resources.Errors;

class DerivedSet<S, E>
extends SetOfUnknownSize<E>
implements CheckedContainer<E>,
Serializable {
    private static final long serialVersionUID = 6309535868745970619L;
    protected final Set<S> storage;
    protected final ObjectConverter<S, E> converter;

    static <S, E> Set<E> create(Set<S> storage, ObjectConverter<S, E> converter) {
        Set<FunctionProperty> properties = converter.properties();
        if (properties.contains((Object)FunctionProperty.INVERTIBLE)) {
            if (FunctionProperty.isBijective(properties)) {
                return new Bijective<S, E>(storage, converter);
            }
            return new Invertible<S, E>(storage, converter);
        }
        return new DerivedSet<S, E>(storage, converter);
    }

    private DerivedSet(Set<S> storage, ObjectConverter<S, E> converter) {
        this.storage = storage;
        this.converter = converter;
    }

    @Override
    public final Class<E> getElementType() {
        return this.converter.getTargetClass();
    }

    @Override
    public final Iterator<E> iterator() {
        return new DerivedIterator<S, E>(this.storage.iterator(), this.converter);
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty() || !this.iterator().hasNext();
    }

    @Override
    public boolean add(E element) throws UnsupportedOperationException {
        return this.add(element, this.converter.inverse().apply(element));
    }

    final boolean add(E original, S element) {
        if (element == null) {
            throw new UnconvertibleObjectException(Errors.format((short)59, "element", original));
        }
        return this.storage.add(element);
    }

    private static final class Bijective<S, E>
    extends Invertible<S, E> {
        private static final long serialVersionUID = -7601944988804380342L;

        Bijective(Set<S> storage, ObjectConverter<S, E> converter) {
            super(storage, converter);
        }

        @Override
        public int size() {
            return this.storage.size();
        }

        @Override
        public boolean isEmpty() {
            return this.storage.isEmpty();
        }
    }

    private static class Invertible<S, E>
    extends DerivedSet<S, E> {
        private static final long serialVersionUID = -5336633027232952482L;
        private final ObjectConverter<E, S> inverse;

        Invertible(Set<S> storage, ObjectConverter<S, E> converter) {
            super(storage, converter);
            this.inverse = converter.inverse();
        }

        @Override
        public final boolean add(E element) throws UnsupportedOperationException {
            return this.add(element, this.inverse.apply(element));
        }

        @Override
        public final boolean contains(Object element) {
            Class type = this.getElementType();
            return type.isInstance(element) && this.storage.contains(this.inverse.apply(type.cast(element)));
        }

        @Override
        public final boolean remove(Object element) throws UnsupportedOperationException {
            Class type = this.getElementType();
            return type.isInstance(element) && this.storage.remove(this.inverse.apply(type.cast(element)));
        }
    }
}

