/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import java.util.ArrayList;
import java.util.List;
import org.apache.royale.compiler.asdoc.royale.ASDocComment;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.utils.DocEmitterUtils;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.scopes.FunctionScope;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.VariableNode;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IAccessorNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IDocumentableDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IFunctionObjectNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;
import org.apache.royale.compiler.tree.as.INamespaceNode;
import org.apache.royale.compiler.tree.as.ITypeNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.utils.ASNodeUtils;

public class ClassEmitter
extends JSSubEmitter
implements ISubEmitter<IClassNode> {
    public ClassEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IClassNode node) {
        IDefinitionNode[] dnodes;
        boolean suppressExport;
        boolean keepASDoc = false;
        boolean verbose = false;
        RoyaleJSProject project = (RoyaleJSProject)this.getEmitter().getWalker().getProject();
        keepASDoc = project.config != null && project.config.getKeepASDoc();
        verbose = project.config != null && project.config.isVerbose();
        boolean isInternal = this.getModel().getInternalClasses().containsKey(node.getName());
        IClassDefinition definition = node.getDefinition();
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        if (isInternal) {
            ASProjectScope projectScope = project.getScope();
            ICompilationUnit cu = projectScope.getCompilationUnitForDefinition((IDefinition)definition);
            ArrayList<String> requiresList = project.getRequires(cu);
            fjs.processBindableSupport(definition, requiresList);
        }
        this.getModel().pushClass(node.getDefinition());
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (asDoc != null && keepASDoc) {
            List<String> ignoreList = DocEmitterUtils.loadImportIgnores(fjs, asDoc.commentNoEnd());
            if (verbose) {
                for (String ignorable : ignoreList) {
                    System.out.println("Found ignorable: " + ignorable);
                }
            }
        }
        this.getModel().suppressExports = suppressExport = ASNodeUtils.hasExportSuppressed((IDocumentableDefinitionNode)node);
        IFunctionDefinition ctorDefinition = definition.getConstructor();
        this.collectUsedNames(node);
        if (ctorDefinition != null) {
            this.emitConstructor(ctorDefinition, definition, node);
        }
        for (IDefinitionNode dnode : dnodes = node.getAllMemberNodes()) {
            this.emitMember(dnode);
        }
        fjs.getBindableEmitter().emit(definition);
        fjs.getAccessorEmitter().emit(definition);
        if (fjs.getFieldEmitter().hasComplexStaticInitializers) {
            this.writeNewline();
            boolean complexInitOutput = false;
            for (IDefinitionNode dnode : dnodes) {
                if (dnode.getNodeID() == ASTNodeID.VariableID) {
                    complexInitOutput = fjs.getFieldEmitter().emitFieldInitializer((IVariableNode)dnode) || complexInitOutput;
                    continue;
                }
                if (dnode.getNodeID() != ASTNodeID.BindableVariableID) continue;
                complexInitOutput = fjs.getFieldEmitter().emitFieldInitializer((IVariableNode)dnode) || complexInitOutput;
            }
            if (complexInitOutput) {
                this.writeNewline();
                this.writeNewline();
            }
        }
        fjs.getPackageFooterEmitter().emitClassInfo((ITypeNode)node);
        this.getModel().popClass();
    }

    public void emitComplexInitializers(IClassNode node) {
        IDefinitionNode[] dnodes;
        boolean wroteSelf = false;
        boolean wroteOne = false;
        for (IDefinitionNode dnode : dnodes = node.getAllMemberNodes()) {
            IVariableNode varnode;
            IExpressionNode vnode;
            if (dnode.getNodeID() != ASTNodeID.VariableID && dnode.getNodeID() != ASTNodeID.BindableVariableID || (vnode = (varnode = (IVariableNode)dnode).getAssignedValueNode()) == null || dnode.getDefinition().isStatic() || EmitterUtils.isScalar(vnode)) continue;
            if (!wroteSelf && vnode instanceof IFunctionObjectNode) {
                this.writeNewline();
                this.writeToken(ASEmitterTokens.VAR);
                this.writeToken(JSGoogEmitterTokens.SELF);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.write(ASEmitterTokens.THIS);
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                wroteSelf = true;
            }
            this.writeNewline();
            this.write(ASEmitterTokens.THIS);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            String dname = dnode.getName();
            IDefinition dDef = dnode.getDefinition();
            if (dDef != null && dDef.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
                dname = this.getEmitter().formatPrivateName(dDef.getParent().getQualifiedName(), dname);
            }
            if (EmitterUtils.isCustomNamespace(varnode.getNamespace())) {
                INamespaceDecorationNode ns = ((VariableNode)varnode).getNamespaceNode();
                INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve(this.getProject());
                this.getEmitter().formatQualifiedName(nsDef.getQualifiedName());
                String s = nsDef.getURI();
                this.write(JSRoyaleEmitter.formatNamespacedProperty(s, dname, false));
            } else {
                this.write(dname);
            }
            if (dnode.getNodeID() == ASTNodeID.BindableVariableID) {
                this.write("_");
            }
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.getEmitter().emitAssignmentCoercion(vnode, varnode.getVariableTypeNode().resolve(this.getProject()));
            this.write(ASEmitterTokens.SEMICOLON);
            wroteOne = true;
        }
        if (wroteOne) {
            this.writeNewline();
        }
    }

    private void emitConstructor(IFunctionDefinition ctorDefinition, IClassDefinition definition, IClassNode node) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        IFunctionNode ctorNode = (IFunctionNode)ctorDefinition.getNode();
        if (ctorNode != null) {
            this.getEmitter().emitMethod(ctorNode);
            this.write(ASEmitterTokens.SEMICOLON);
        } else {
            String qname = definition.getQualifiedName();
            if (qname != null && !qname.equals("")) {
                if (fjs.getModel().isExterns && definition.getBaseName().equals(qname)) {
                    this.writeToken(ASEmitterTokens.VAR);
                }
                this.write(this.getEmitter().formatQualifiedName(qname));
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.write(ASEmitterTokens.FUNCTION);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.BLOCK_OPEN);
                this.writeNewline();
                fjs.emitComplexInitializers(node);
                this.write(ASEmitterTokens.BLOCK_CLOSE);
                this.write(ASEmitterTokens.SEMICOLON);
            }
        }
    }

    private void collectUsedNames(IClassNode node) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        int childNodeCount = node.getChildCount();
        for (int i = 0; i < childNodeCount; ++i) {
            IASNode child = node.getChild(i);
            if (child.getNodeID() != ASTNodeID.BlockID) continue;
            int blockNodeCount = child.getChildCount();
            for (int j = 0; j < blockNodeCount - 1; ++j) {
                IDefinition def;
                IASNode afterChild;
                IASNode blockChild = child.getChild(j);
                if (blockChild.getNodeID() != ASTNodeID.ImportID || (afterChild = child.getChild(j + 1)).getNodeID() != ASTNodeID.IdentifierID || !((def = ((IdentifierNode)afterChild).resolve(this.getWalker().getProject())) instanceof IClassDefinition)) continue;
                fjs.usedNames.add(def.getQualifiedName());
            }
            break;
        }
    }

    private void emitMember(IDefinitionNode dnode) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        if (dnode.getNodeID() == ASTNodeID.VariableID) {
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            this.getEmitter().emitField((IVariableNode)dnode);
            this.startMapping((ISourceLocation)dnode, (ISourceLocation)dnode);
            this.write(ASEmitterTokens.SEMICOLON);
            this.endMapping((ISourceLocation)dnode);
        } else if (dnode.getNodeID() == ASTNodeID.FunctionID) {
            if (!((IFunctionNode)dnode).isConstructor()) {
                this.writeNewline();
                this.writeNewline();
                this.writeNewline();
                this.getEmitter().emitMethod((IFunctionNode)dnode);
                this.write(ASEmitterTokens.SEMICOLON);
                if (this.getModel().defaultXMLNamespaceActive.booleanValue()) {
                    this.getModel().registerDefaultXMLNamespace((FunctionScope)((IFunctionNode)dnode).getScopedNode().getScope(), null);
                }
            }
        } else if (dnode.getNodeID() == ASTNodeID.GetterID || dnode.getNodeID() == ASTNodeID.SetterID) {
            fjs.emitAccessors((IAccessorNode)dnode);
        } else if (dnode.getNodeID() == ASTNodeID.BindableVariableID) {
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            this.getEmitter().emitField((IVariableNode)dnode);
            this.startMapping((ISourceLocation)dnode, (ISourceLocation)dnode);
            this.write(ASEmitterTokens.SEMICOLON);
            this.endMapping((ISourceLocation)dnode);
        } else if (dnode.getNodeID() == ASTNodeID.NamespaceID) {
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            this.getEmitter().emitNamespace((INamespaceNode)dnode);
            this.startMapping((ISourceLocation)dnode, (ISourceLocation)dnode);
            this.write(ASEmitterTokens.SEMICOLON);
            this.endMapping((ISourceLocation)dnode);
        }
    }
}

