/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.container;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.tieredstore.common.AppendResult;
import org.apache.rocketmq.tieredstore.common.BoundaryType;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.container.TieredFileQueue;
import org.apache.rocketmq.tieredstore.provider.TieredFileSegment;

public class TieredConsumeQueue {
    public static final int CONSUME_QUEUE_STORE_UNIT_SIZE = 20;
    private final MessageQueue messageQueue;
    private final TieredMessageStoreConfig storeConfig;
    private final TieredFileQueue fileQueue;

    public TieredConsumeQueue(MessageQueue messageQueue, TieredMessageStoreConfig storeConfig) throws ClassNotFoundException, NoSuchMethodException {
        this.messageQueue = messageQueue;
        this.storeConfig = storeConfig;
        this.fileQueue = new TieredFileQueue(TieredFileSegment.FileSegmentType.CONSUME_QUEUE, messageQueue, storeConfig);
    }

    public boolean isInitialized() {
        return this.fileQueue.getBaseOffset() != -1L;
    }

    public long getBaseOffset() {
        return this.fileQueue.getBaseOffset();
    }

    public void setBaseOffset(long baseOffset) {
        this.fileQueue.setBaseOffset(baseOffset);
    }

    public long getMinOffset() {
        return this.fileQueue.getMinOffset();
    }

    public long getCommitOffset() {
        return this.fileQueue.getCommitOffset();
    }

    public long getMaxOffset() {
        return this.fileQueue.getMaxOffset();
    }

    public long getEndTimestamp() {
        return this.fileQueue.getFileToWrite().getEndTimestamp();
    }

    public AppendResult append(long offset, int size, long tagsCode, long timeStamp) {
        return this.append(offset, size, tagsCode, timeStamp, false);
    }

    public AppendResult append(long offset, int size, long tagsCode, long timeStamp, boolean commit) {
        ByteBuffer cqItem = ByteBuffer.allocate(20);
        cqItem.putLong(offset);
        cqItem.putInt(size);
        cqItem.putLong(tagsCode);
        cqItem.flip();
        return this.fileQueue.append(cqItem, timeStamp, commit);
    }

    public CompletableFuture<ByteBuffer> readAsync(long offset, int length) {
        return this.fileQueue.readAsync(offset, length);
    }

    public void commit(boolean sync) {
        this.fileQueue.commit(sync);
    }

    public void cleanExpiredFile(long expireTimestamp) {
        this.fileQueue.cleanExpiredFile(expireTimestamp);
    }

    public void destroyExpiredFile() {
        this.fileQueue.destroyExpiredFile();
    }

    protected Pair<Long, Long> getQueueOffsetInFileByTime(long timestamp, BoundaryType boundaryType) {
        TieredFileSegment fileSegment = this.fileQueue.getFileByTime(timestamp, boundaryType);
        if (fileSegment == null) {
            return Pair.of((Object)-1L, (Object)-1L);
        }
        return Pair.of((Object)(fileSegment.getBaseOffset() / 20L), (Object)(fileSegment.getCommitOffset() / 20L - 1L));
    }

    public void destroy() {
        this.fileQueue.destroy();
    }
}

