/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.common;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.ThreadFactoryImpl;

public class TieredStoreExecutor {
    private static final int QUEUE_CAPACITY = 10000;
    public static ExecutorService dispatchExecutor;
    public static ScheduledExecutorService commonScheduledExecutor;
    public static ScheduledExecutorService commitExecutor;
    public static ScheduledExecutorService cleanExpiredFileExecutor;
    public static ExecutorService fetchDataExecutor;
    public static ExecutorService compactIndexFileExecutor;

    public static void init() {
        LinkedBlockingQueue<Runnable> dispatchThreadPoolQueue = new LinkedBlockingQueue<Runnable>(10000);
        dispatchExecutor = new ThreadPoolExecutor(Math.max(2, Runtime.getRuntime().availableProcessors()), Math.max(16, Runtime.getRuntime().availableProcessors() * 4), 60000L, TimeUnit.MILLISECONDS, dispatchThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("TieredCommonExecutor_"));
        commonScheduledExecutor = new ScheduledThreadPoolExecutor(Math.max(4, Runtime.getRuntime().availableProcessors()), (ThreadFactory)new ThreadFactoryImpl("TieredCommonScheduledExecutor_"));
        commitExecutor = new ScheduledThreadPoolExecutor(Math.max(16, Runtime.getRuntime().availableProcessors() * 4), (ThreadFactory)new ThreadFactoryImpl("TieredCommitExecutor_"));
        cleanExpiredFileExecutor = new ScheduledThreadPoolExecutor(Math.max(4, Runtime.getRuntime().availableProcessors()), (ThreadFactory)new ThreadFactoryImpl("TieredCleanExpiredFileExecutor_"));
        LinkedBlockingQueue<Runnable> fetchDataThreadPoolQueue = new LinkedBlockingQueue<Runnable>(10000);
        fetchDataExecutor = new ThreadPoolExecutor(Math.max(16, Runtime.getRuntime().availableProcessors() * 4), Math.max(64, Runtime.getRuntime().availableProcessors() * 8), 60000L, TimeUnit.MILLISECONDS, fetchDataThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("TieredFetchDataExecutor_"));
        LinkedBlockingQueue<Runnable> compactIndexFileThreadPoolQueue = new LinkedBlockingQueue<Runnable>(10000);
        compactIndexFileExecutor = new ThreadPoolExecutor(1, 1, 60000L, TimeUnit.MILLISECONDS, compactIndexFileThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("TieredCompactIndexFileExecutor_"));
    }

    public static void shutdown() {
        TieredStoreExecutor.shutdownExecutor(dispatchExecutor);
        TieredStoreExecutor.shutdownExecutor(commonScheduledExecutor);
        TieredStoreExecutor.shutdownExecutor(commitExecutor);
        TieredStoreExecutor.shutdownExecutor(cleanExpiredFileExecutor);
        TieredStoreExecutor.shutdownExecutor(fetchDataExecutor);
        TieredStoreExecutor.shutdownExecutor(compactIndexFileExecutor);
    }

    private static void shutdownExecutor(ExecutorService executor) {
        if (executor != null) {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
            }
        }
    }
}

