/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utils {
    public static void cleanup(Logger logger, EnvironmentImpl envImpl, Formatter formatter, DataChannel channel, BufferedReader in, PrintWriter out) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (out != null) {
            out.close();
        }
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                LoggerUtils.logMsg(logger, envImpl, formatter, Level.FINE, "Channel exception on close: " + e.getMessage());
            }
        }
    }

    public static FutureTrackingCompService<TextProtocol.MessageExchange> broadcastMessage(Set<InetSocketAddress> targets, String serviceName, TextProtocol.RequestMessage requestMessage, ExecutorService threadPool) {
        FutureTrackingCompService<TextProtocol.MessageExchange> compService = new FutureTrackingCompService<TextProtocol.MessageExchange>(threadPool);
        for (InetSocketAddress socketAddress : targets) {
            TextProtocol textProtocol = requestMessage.getProtocol();
            textProtocol.getClass();
            TextProtocol.MessageExchange me = new TextProtocol.MessageExchange(textProtocol, socketAddress, serviceName, requestMessage);
            try {
                compService.submit(me, me);
            }
            catch (RejectedExecutionException ree) {
                if (threadPool.isTerminated()) {
                    compService.cancelFutures(true);
                    return compService;
                }
                throw ree;
            }
        }
        return compService;
    }

    public static void checkFutures(FutureTrackingCompService<TextProtocol.MessageExchange> compService, long futureTimeout, TimeUnit unit, Logger logger, final RepImpl envImpl, Formatter formatter) {
        new WithFutureExceptionHandler<TextProtocol.MessageExchange>(compService, futureTimeout, unit, logger, envImpl, formatter){

            @Override
            protected void processResponse(TextProtocol.MessageExchange result) {
            }

            @Override
            protected boolean isShutdown() {
                return envImpl != null && !envImpl.isValid();
            }
        }.execute();
    }

    public static class FutureTrackingCompService<V>
    extends ExecutorCompletionService<V> {
        private final List<Future<V>> futures = new LinkedList<Future<V>>();

        public FutureTrackingCompService(Executor executor) {
            super(executor);
        }

        public List<Future<V>> getFutures() {
            return this.futures;
        }

        @Override
        public Future<V> submit(Runnable task, V result) {
            Future<V> f = super.submit(task, result);
            this.futures.add(f);
            return f;
        }

        @Override
        public Future<V> submit(Callable<V> task) {
            Future<V> f = super.submit(task);
            this.futures.add(f);
            return f;
        }

        public void cancelFutures(boolean mayInterruptIfRunning) {
            for (Future<V> f : this.futures) {
                if (f.isCancelled()) continue;
                f.cancel(mayInterruptIfRunning);
            }
        }
    }

    public static abstract class WithFutureExceptionHandler<T extends TextProtocol.MessageExchange> {
        private final FutureTrackingCompService<T> completionService;
        private final long completionTimeout;
        private final TimeUnit unit;
        private final Logger logger;
        private final RepImpl envImpl;
        private final Formatter formatter;

        public WithFutureExceptionHandler(FutureTrackingCompService<T> compService, long completionTimeout, TimeUnit unit, Logger logger, RepImpl envImpl, Formatter formatter) {
            this.completionService = compService;
            this.completionTimeout = completionTimeout;
            this.unit = unit;
            this.logger = logger;
            this.envImpl = envImpl;
            this.formatter = formatter;
        }

        protected abstract void processResponse(T var1);

        void processNullResponse(T result) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "No response from: " + ((TextProtocol.MessageExchange)result).target + " request" + ((TextProtocol.MessageExchange)result).getRequestMessage() + " reason: " + ((TextProtocol.MessageExchange)result).exception);
        }

        protected abstract boolean isShutdown();

        public final void execute() {
            long limitTimeMs = System.currentTimeMillis() + this.unit.toMillis(this.completionTimeout);
            try {
                for (int count = this.completionService.getFutures().size(); count > 0; --count) {
                    long pollTimeoutMs = limitTimeMs - System.currentTimeMillis();
                    if (pollTimeoutMs <= 0L) {
                        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Election messages timed out after " + this.unit.toMillis(this.completionTimeout) + "ms.");
                        return;
                    }
                    Future f = this.completionService.poll(pollTimeoutMs, TimeUnit.MILLISECONDS);
                    if (f == null) {
                        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Election messages timed out after " + this.unit.toMillis(this.completionTimeout) + "ms.");
                        return;
                    }
                    if (this.isShutdown()) {
                        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Election messages terminated. Environment being shutdown.");
                        return;
                    }
                    if (f.isCancelled()) continue;
                    long futureTimeoutMs = limitTimeMs - System.currentTimeMillis();
                    if (futureTimeoutMs <= 0L) {
                        return;
                    }
                    assert (f.isDone());
                    this.executeInternal(f);
                }
            }
            catch (InterruptedException e) {
                RepNode rn;
                if (this.envImpl != null && (rn = this.envImpl.getRepNode()) != null && rn.isShutdown()) {
                    LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Election operation interrupted. Environment being shutdown.");
                    return;
                }
                throw EnvironmentFailureException.unexpectedException(e);
            }
            finally {
                this.completionService.cancelFutures(true);
            }
        }

        private final void executeInternal(Future<T> future) throws InterruptedException {
            try {
                assert (future.isDone());
                TextProtocol.MessageExchange result = (TextProtocol.MessageExchange)future.get();
                if (result.getResponseMessage() == null) {
                    this.processNullResponse(result);
                } else {
                    this.processResponse(result);
                }
            }
            catch (CancellationException result) {
            }
            catch (ExecutionException e) {
                Throwable t;
                Exception cause = (Exception)e.getCause();
                while (cause instanceof RuntimeException && (t = ((RuntimeException)cause).getCause()) != null && t instanceof Exception) {
                    cause = (Exception)t;
                }
                if (cause instanceof ConnectException || cause instanceof SocketException || cause instanceof SocketTimeoutException || cause instanceof ServiceDispatcher.ServiceConnectFailedException) {
                    LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Election connection failure " + cause.getMessage());
                    return;
                }
                throw EnvironmentFailureException.unexpectedException(e);
            }
        }
    }
}

