/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.preferences;

import java.security.Principal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.preferences.GenericPrincipal;
import org.apache.qpid.server.model.preferences.Preference;
import org.apache.qpid.server.model.preferences.PreferenceImpl;
import org.apache.qpid.server.model.preferences.PreferenceValue;
import org.apache.qpid.server.model.preferences.PreferenceValueFactoryService;
import org.apache.qpid.server.plugin.QpidServiceLoader;

public class PreferenceFactory {
    public static Preference fromAttributes(ConfiguredObject<?> associatedObject, Map<String, Object> attributes) {
        UUID uuid = PreferenceFactory.getId(attributes);
        String type = PreferenceFactory.getAttributeAsString("type", attributes);
        String name = PreferenceFactory.getAttributeAsString("name", attributes);
        String description = PreferenceFactory.getAttributeAsString("description", attributes);
        Principal owner = PreferenceFactory.getOwner(attributes);
        Set<Principal> visibilitySet = PreferenceFactory.getVisibilitySet(attributes);
        Date lastUpdatedDate = PreferenceFactory.getAttributeAsDate("lastUpdatedDate", attributes);
        Date createdDate = PreferenceFactory.getAttributeAsDate("createdDate", attributes);
        Map<String, Object> preferenceValueAttributes = PreferenceFactory.getPreferenceValue(attributes);
        PreferenceValue value = PreferenceFactory.convertMapToPreferenceValue(type, preferenceValueAttributes);
        return new PreferenceImpl(associatedObject, uuid, name, type, description, owner, lastUpdatedDate, createdDate, visibilitySet, value);
    }

    private static UUID getId(Map<String, Object> attributes) {
        Object id = attributes.get("id");
        UUID uuid = null;
        if (id != null) {
            if (id instanceof UUID) {
                uuid = (UUID)id;
            } else if (id instanceof String) {
                uuid = UUID.fromString((String)id);
            } else {
                throw new IllegalArgumentException(String.format("Preference attribute '%s' is not a UUID", "id"));
            }
        }
        return uuid;
    }

    private static Map<String, Object> getPreferenceValue(Map<String, Object> attributes) {
        Object value = attributes.get("value");
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            HashMap<String, Object> preferenceValue = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    preferenceValue.put((String)key, entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException(String.format("Invalid value entry: '%s' is not a String", key));
            }
            return preferenceValue;
        }
        throw new IllegalArgumentException(String.format("Cannot recover '%s' as Map", "value"));
    }

    private static Set<Principal> getVisibilitySet(Map<String, Object> attributes) {
        Object value = attributes.get("visibilityList");
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            HashSet<Principal> principals = new HashSet<Principal>();
            for (Object element : (Collection)value) {
                if (element instanceof String) {
                    principals.add(new GenericPrincipal((String)element));
                    continue;
                }
                if (element instanceof Principal) {
                    principals.add((Principal)element);
                    continue;
                }
                String errorMessage = String.format("Invalid visibilityList element: '%s' is not of expected type.", element);
                throw new IllegalArgumentException(errorMessage);
            }
            return principals;
        }
        throw new IllegalArgumentException(String.format("Cannot recover '%s' as List", "visibilityList"));
    }

    private static Principal getOwner(Map<String, Object> attributes) {
        Object value = attributes.get("owner");
        if (value == null || value instanceof Principal) {
            return (Principal)value;
        }
        if (value instanceof String) {
            return new GenericPrincipal((String)value);
        }
        throw new IllegalArgumentException(String.format("Cannot recover '%s' as Principal", "owner"));
    }

    private static String getAttributeAsString(String attributeName, Map<String, Object> attributes) {
        Object value = attributes.get(attributeName);
        if (value == null || value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException(String.format("Preference attribute '%s' is not a String", attributeName));
    }

    private static Date getAttributeAsDate(String attributeName, Map<String, Object> attributes) {
        Object dateObject = attributes.get(attributeName);
        if (dateObject instanceof Date) {
            return new Date(((Date)dateObject).getTime());
        }
        if (dateObject instanceof Number) {
            return new Date(((Number)dateObject).longValue());
        }
        return new Date();
    }

    private static PreferenceValue convertMapToPreferenceValue(String type, Map<String, Object> preferenceValueAttributes) {
        Map<String, PreferenceValueFactoryService> preferenceValueFactories;
        PreferenceValueFactoryService preferenceValueFactory;
        String implementationType = type;
        if (type != null && type.startsWith("X-")) {
            implementationType = "X-generic";
        }
        if ((preferenceValueFactory = (preferenceValueFactories = new QpidServiceLoader().getInstancesByType(PreferenceValueFactoryService.class)).get(implementationType)) == null) {
            throw new IllegalArgumentException(String.format("Cannot find preference type factory for type '%s'", implementationType));
        }
        return preferenceValueFactory.createInstance(preferenceValueAttributes);
    }
}

