/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.channel.uring;

import io.netty.incubator.channel.uring.IOUringCompletionQueue;
import io.netty.incubator.channel.uring.IOUringSubmissionQueue;
import io.netty.incubator.channel.uring.Native;

final class RingBuffer {
    private final IOUringSubmissionQueue ioUringSubmissionQueue;
    private final IOUringCompletionQueue ioUringCompletionQueue;

    RingBuffer(IOUringSubmissionQueue ioUringSubmissionQueue, IOUringCompletionQueue ioUringCompletionQueue) {
        this.ioUringSubmissionQueue = ioUringSubmissionQueue;
        this.ioUringCompletionQueue = ioUringCompletionQueue;
    }

    int fd() {
        return this.ioUringCompletionQueue.ringFd;
    }

    IOUringSubmissionQueue ioUringSubmissionQueue() {
        return this.ioUringSubmissionQueue;
    }

    IOUringCompletionQueue ioUringCompletionQueue() {
        return this.ioUringCompletionQueue;
    }

    void close() {
        this.ioUringSubmissionQueue.release();
        Native.ioUringExit(this.ioUringSubmissionQueue.submissionQueueArrayAddress, this.ioUringSubmissionQueue.ringEntries, this.ioUringSubmissionQueue.ringAddress, this.ioUringSubmissionQueue.ringSize, this.ioUringCompletionQueue.ringAddress, this.ioUringCompletionQueue.ringSize, this.ioUringCompletionQueue.ringFd);
    }
}

