/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.launch.Locator;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.antmod.ProjectHelper3;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;
import org.tp23.antinstaller.selfextract.SelfExtractor;

public class AntProjectFilter
implements ExecuteFilter {
    private static String antVersion = null;
    public static final String ANTHOME_PROPERTY = "ant.home";
    public static final String USER_LIBDIR = ".ant/lib";
    static /* synthetic */ Class class$org$tp23$antinstaller$runtime$exe$AntProjectFilter;

    public void exec(InstallerContext ctx) throws InstallException {
        if (ctx.getInstaller().isVerbose()) {
            ctx.log("Starting Ant Project");
        }
        try {
            Project project = new Project();
            AntProjectFilter.appendClassPath();
            AntProjectFilter.setAntHome(ctx);
            project.setCoreLoader(this.getClass().getClassLoader());
            DefaultLogger antLogger = new DefaultLogger();
            antLogger.setOutputPrintStream(ctx.getAntOutputRenderer().getOut());
            antLogger.setErrorPrintStream(ctx.getAntOutputRenderer().getErr());
            antLogger.setMessageOutputLevel(2);
            BuildListener bl = ctx.getBuildListener();
            if (bl != null) {
                project.addBuildListener(bl);
            }
            project.addBuildListener(antLogger);
            String logFileName = ctx.getLogger().getFileName();
            if (logFileName != null && logFileName.length() > 0) {
                PrintStream stream = new PrintStream(new FileOutputStream(logFileName, true), true);
                DefaultLogger antFileLogger = new DefaultLogger();
                antFileLogger.setOutputPrintStream(stream);
                antFileLogger.setErrorPrintStream(stream);
                int logLevel = ctx.getInstaller().isVerbose() ? 3 : 2;
                antFileLogger.setMessageOutputLevel(logLevel);
                project.addBuildListener(antFileLogger);
            }
            project.setInputHandler(new DefaultInputHandler());
            project.fireBuildStarted();
            project.init();
            project.setUserProperty("ant.version", AntProjectFilter.getAntVersion());
            Map properties = ctx.getInstaller().getResultContainer().getAllProperties();
            Iterator iter = properties.keySet().iterator();
            while (iter.hasNext()) {
                String arg = (String)iter.next();
                String value = (String)properties.get(arg);
                project.setUserProperty(arg, value);
            }
            try {
                Diagnostics.validateVersion();
            }
            catch (Throwable exc) {
                System.err.println("Version error:" + exc.getClass() + "," + exc.getMessage());
                ctx.getRunner().antFinished();
                return;
            }
            ProjectHelper3 helper = new ProjectHelper3();
            project.addReference("ant.projectHelper", helper);
            File buildXml = new File(ctx.getFileRoot(), ctx.getAntBuildFile());
            if (buildXml.exists()) {
                ((ProjectHelper)helper).parse(project, buildXml);
                project.setUserProperty("ant.file", buildXml.getAbsolutePath());
            } else {
                URL buildIS = this.getClass().getResource("/" + ctx.getAntBuildFile());
                ((ProjectHelper)helper).parse(project, buildIS);
                project.setUserProperty("ant.file", buildIS.toExternalForm());
            }
            File enclosingJar = SelfExtractor.getEnclosingJar(this);
            project.setUserProperty("antinstaller.jar", enclosingJar.getAbsolutePath());
            System.out.println("antinstaller.jar" + enclosingJar.getAbsolutePath());
            project.setBaseDir(ctx.getFileRoot());
            project.executeTargets(ctx.getInstaller().getTargets(ctx));
            project.fireBuildFinished(null);
            ctx.setInstallSucceded(true);
            ctx.log("Ant finished");
        }
        catch (Throwable e) {
            throw new InstallException("Error running the install, " + e.getMessage(), e);
        }
        finally {
            ctx.getRunner().antFinished();
        }
    }

    public static synchronized String getAntVersion() throws BuildException {
        if (antVersion == null) {
            try {
                Properties props = new Properties();
                InputStream in = (class$org$tp23$antinstaller$runtime$exe$AntProjectFilter == null ? (class$org$tp23$antinstaller$runtime$exe$AntProjectFilter = AntProjectFilter.class$("org.tp23.antinstaller.runtime.exe.AntProjectFilter")) : class$org$tp23$antinstaller$runtime$exe$AntProjectFilter).getResourceAsStream("/org/apache/tools/ant/version.txt");
                props.load(in);
                in.close();
                StringBuffer msg = new StringBuffer();
                msg.append("Apache Ant version ");
                msg.append(props.getProperty("VERSION"));
                msg.append(" compiled on ");
                msg.append(props.getProperty("DATE"));
                antVersion = msg.toString();
            }
            catch (IOException ioe) {
                throw new BuildException("Could not load the version information:" + ioe.getMessage());
            }
            catch (NullPointerException npe) {
                throw new BuildException("Could not load the version information.");
            }
        }
        return antVersion;
    }

    private static void appendClassPath() {
        try {
            StringBuffer baseClassPath = new StringBuffer(System.getProperty("java.class.path"));
            if (baseClassPath.charAt(baseClassPath.length() - 1) == File.pathSeparatorChar) {
                baseClassPath.setLength(baseClassPath.length() - 1);
            }
            URL[] jars = AntProjectFilter.getLibPaths();
            for (int i = 0; i < jars.length; ++i) {
                baseClassPath.append(File.pathSeparatorChar);
                baseClassPath.append(Locator.fromURI(jars[i].toString()));
            }
            System.setProperty("java.class.path", baseClassPath.toString());
            URLClassLoader loader = new URLClassLoader(jars);
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (MalformedURLException e) {
            System.err.println("Invalid Jar path");
        }
    }

    private static void setAntHome(InstallerContext ctx) {
        String antHomeProperty = System.getProperty(ANTHOME_PROPERTY);
        if (antHomeProperty == null) {
            System.setProperty(ANTHOME_PROPERTY, ctx.getFileRoot().getAbsolutePath());
        }
    }

    private static URL[] getLibPaths() throws MalformedURLException {
        URL[] libJars = Locator.getLocationURLs(new File("antlib"));
        URL[] userJars = Locator.getLocationURLs(new File(USER_LIBDIR));
        File toolsJar = Locator.getToolsJar();
        int jarsLength = libJars.length + userJars.length + (toolsJar != null ? 1 : 0);
        URL[] allJars = new URL[jarsLength];
        int i = 0;
        if (toolsJar != null) {
            allJars[i++] = toolsJar.toURL();
        }
        if (libJars.length != 0) {
            System.arraycopy(libJars, 0, allJars, i, libJars.length);
            i += libJars.length;
        }
        if (userJars.length != 0) {
            System.arraycopy(userJars, 0, allJars, i, userJars.length);
        }
        return libJars;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

