/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.webbeans.test.events.extensionevents;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.ProcessObserverMethod;


/**
 * This is a standard CDI bean which Observes Object.class.
 * This should not result in getting any
 */
@ApplicationScoped
public class ShouldNotCatchExtensionEventBean
{

    public static boolean extensionEventInvoked = false;

    public void catchItAll(@Observes Object all)
    {
        if (all instanceof AfterBeanDiscovery || all instanceof AfterDeploymentValidation
            || all instanceof ProcessObserverMethod)
        {
            extensionEventInvoked = true;
        }
    }
}
