/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.transport;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.PortMapperImpl;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public final class HttpsRedirectFilter
extends OncePerRequestFilter {
    private PortMapper portMapper = new PortMapperImpl();
    private RequestMatcher requestMatcher = AnyRequestMatcher.INSTANCE;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (!this.isInsecure(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!this.requestMatcher.matches(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String redirectUri = this.createRedirectUri(request);
        this.redirectStrategy.sendRedirect(request, response, redirectUri);
    }

    public void setPortMapper(PortMapper portMapper) {
        Assert.notNull((Object)portMapper, (String)"portMapper cannot be null");
        this.portMapper = portMapper;
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.requestMatcher = requestMatcher;
    }

    private boolean isInsecure(HttpServletRequest request) {
        return !"https".equals(request.getScheme());
    }

    private String createRedirectUri(HttpServletRequest request) {
        String url = UrlUtils.buildFullRequestUrl(request);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)url);
        UriComponents components = builder.build();
        int port = components.getPort();
        if (port > 0) {
            Integer httpsPort = this.portMapper.lookupHttpsPort(port);
            Assert.state((httpsPort != null ? 1 : 0) != 0, () -> "HTTP Port '" + port + "' does not have a corresponding HTTPS Port");
            builder.port(httpsPort.intValue());
        }
        return builder.scheme("https").toUriString();
    }
}

