/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.init;

import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.init.ConfigurableComponentInitializer;
import org.apache.nifi.init.ReflectionUtils;
import org.apache.nifi.mock.MockComponentLogger;
import org.apache.nifi.mock.MockConfigurationContext;
import org.apache.nifi.mock.MockParameterProviderInitializationContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.ParameterProvider;
import org.apache.nifi.parameter.ParameterProviderInitializationContext;
import org.apache.nifi.reporting.InitializationException;

public class ParameterProviderInitializer
implements ConfigurableComponentInitializer {
    private final ExtensionManager extensionManager;

    public ParameterProviderInitializer(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Override
    public void initialize(ConfigurableComponent component) throws InitializationException {
        ParameterProvider parameterProvider = (ParameterProvider)component;
        MockParameterProviderInitializationContext context = new MockParameterProviderInitializationContext();
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader(this.extensionManager, component.getClass(), context.getIdentifier());){
            parameterProvider.initialize((ParameterProviderInitializationContext)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void teardown(ConfigurableComponent component) {
        ParameterProvider parameterProvider = (ParameterProvider)component;
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader(this.extensionManager, component.getClass(), component.getIdentifier());){
            MockConfigurationContext context = new MockConfigurationContext();
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, parameterProvider, new MockComponentLogger(), context);
        }
        finally {
            this.extensionManager.removeInstanceClassLoader(component.getIdentifier());
        }
    }
}

