/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.EventBasedWorker;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.WorkerQueue;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.util.Connectables;

public class EventDrivenWorkerQueue
implements WorkerQueue {
    private final Object workMonitor = new Object();
    private final Map<Connectable, Worker> workerMap = new HashMap<Connectable, Worker>();
    private final WorkerReadyQueue workerQueue;

    public EventDrivenWorkerQueue(boolean clustered, boolean primary, ProcessScheduler scheduler) {
        this.workerQueue = new WorkerReadyQueue(scheduler);
        this.workerQueue.setClustered(clustered);
        this.workerQueue.setPrimary(primary);
    }

    public void setClustered(boolean clustered) {
        this.workerQueue.setClustered(clustered);
    }

    public void setPrimary(boolean primary) {
        this.workerQueue.setPrimary(primary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worker poll(long timeout, TimeUnit timeUnit) {
        long maxTime = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        while (System.currentTimeMillis() < maxTime) {
            Object object = this.workMonitor;
            synchronized (object) {
                Worker worker = this.workerQueue.poll();
                if (worker == null) {
                    long timeLeft = maxTime - System.currentTimeMillis();
                    if (timeLeft <= 0L) {
                        return null;
                    }
                    try {
                        this.workMonitor.wait(timeLeft);
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                } else {
                    int workLeft = worker.decrementEventCount();
                    if (workLeft > 0) {
                        this.workerQueue.offer(worker);
                    }
                    return worker;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(Connectable connectable) {
        Object object = this.workMonitor;
        synchronized (object) {
            Worker worker = this.workerMap.get(connectable);
            if (worker == null) {
                return;
            }
            int countBefore = worker.incrementEventCount();
            if (countBefore < 0) {
                worker.setWorkCount(1);
            }
            if (countBefore <= 0) {
                this.workerQueue.offer(worker);
            }
            this.workMonitor.notify();
        }
    }

    private int getWorkCount(Connectable connectable) {
        int sum = 0;
        for (Connection connection : connectable.getIncomingConnections()) {
            sum += connection.getFlowFileQueue().size().getObjectCount();
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeWork(Connectable connectable) {
        Object object = this.workMonitor;
        synchronized (object) {
            int workCount = this.getWorkCount(connectable);
            Worker worker = new Worker(connectable);
            this.workerMap.put(connectable, worker);
            if (workCount > 0) {
                worker.setWorkCount(workCount);
                this.workerQueue.offer(worker);
                this.workMonitor.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendWork(Connectable connectable) {
        Object object = this.workMonitor;
        synchronized (object) {
            Worker worker = this.workerMap.remove(connectable);
            if (worker == null) {
                return;
            }
            worker.resetWorkCount();
            this.workerQueue.remove(worker);
        }
    }

    private static enum DelayProcessingReason {
        YIELDED,
        DESTINATION_FULL,
        NO_WORK,
        ALL_WORK_PENALIZED,
        ISOLATED,
        NOT_RUNNING,
        TOO_MANY_THREADS;

    }

    private static class WorkerReadyQueue
    extends LinkedList<Worker> {
        private final ProcessScheduler scheduler;
        private volatile boolean clustered = false;
        private volatile boolean primary = false;

        public WorkerReadyQueue(ProcessScheduler scheduler) {
            this.scheduler = scheduler;
        }

        public void setClustered(boolean clustered) {
            this.clustered = clustered;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Worker poll() {
            ArrayList<Worker> putBack = new ArrayList<Worker>();
            try {
                Worker worker;
                block7: while ((worker = (Worker)super.poll()) != null) {
                    DelayProcessingReason reason = this.getDelayReason(worker);
                    if (reason == null) {
                        Worker worker2 = worker;
                        return worker2;
                    }
                    switch (reason) {
                        case YIELDED: 
                        case ISOLATED: 
                        case DESTINATION_FULL: 
                        case ALL_WORK_PENALIZED: 
                        case NO_WORK: 
                        case TOO_MANY_THREADS: {
                            putBack.add(worker);
                            continue block7;
                        }
                    }
                    worker.resetWorkCount();
                }
            }
            finally {
                if (!putBack.isEmpty()) {
                    super.addAll(putBack);
                }
            }
            return null;
        }

        private DelayProcessingReason getDelayReason(Worker worker) {
            Connectable connectable = worker.getConnectable();
            if (ScheduledState.RUNNING != connectable.getScheduledState()) {
                return DelayProcessingReason.NOT_RUNNING;
            }
            if (connectable.getYieldExpiration() > System.currentTimeMillis()) {
                return DelayProcessingReason.YIELDED;
            }
            int availableRelationshipCount = 0;
            if (!connectable.getRelationships().isEmpty() && (availableRelationshipCount = this.getAvailableRelationshipCount(connectable)) == 0) {
                return DelayProcessingReason.DESTINATION_FULL;
            }
            if (connectable.hasIncomingConnection() && !Connectables.flowFilesQueued((Connectable)connectable)) {
                return DelayProcessingReason.NO_WORK;
            }
            int activeThreadCount = this.scheduler.getActiveThreadCount((Object)worker.getConnectable());
            int maxThreadCount = worker.getConnectable().getMaxConcurrentTasks();
            if (maxThreadCount > 0 && activeThreadCount >= maxThreadCount) {
                return DelayProcessingReason.TOO_MANY_THREADS;
            }
            if (connectable instanceof ProcessorNode) {
                boolean allDestinationsAvailable;
                ProcessorNode procNode = (ProcessorNode)connectable;
                if (procNode.isIsolated() && this.clustered && !this.primary) {
                    return DelayProcessingReason.ISOLATED;
                }
                boolean triggerWhenAnyAvailable = procNode.isTriggerWhenAnyDestinationAvailable();
                boolean bl = allDestinationsAvailable = availableRelationshipCount == procNode.getRelationships().size();
                if (!triggerWhenAnyAvailable && !allDestinationsAvailable) {
                    return DelayProcessingReason.DESTINATION_FULL;
                }
            }
            return null;
        }

        private int getAvailableRelationshipCount(Connectable connectable) {
            int count = 0;
            for (Relationship relationship : connectable.getRelationships()) {
                Set connections = connectable.getConnections(relationship);
                if (connections == null || connections.isEmpty()) {
                    if (!connectable.isAutoTerminated(relationship)) continue;
                    ++count;
                    continue;
                }
                boolean available = true;
                for (Connection connection : connections) {
                    if (connection.getSource() == connection.getDestination() || !connection.getFlowFileQueue().isFull()) continue;
                    available = false;
                }
                if (!available) continue;
                ++count;
            }
            return count;
        }
    }

    public static class Worker
    implements EventBasedWorker {
        private final Connectable connectable;
        private final AtomicInteger workCount = new AtomicInteger(0);

        public Worker(Connectable connectable) {
            this.connectable = connectable;
        }

        public Connectable getConnectable() {
            return this.connectable;
        }

        public int decrementEventCount() {
            return this.workCount.decrementAndGet();
        }

        public int incrementEventCount() {
            return this.workCount.getAndIncrement();
        }

        void resetWorkCount() {
            this.workCount.set(0);
        }

        void setWorkCount(int workCount) {
            this.workCount.set(workCount);
        }
    }
}

