/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.security.util.KeyDerivationFunction;
import org.apache.nifi.security.util.crypto.Argon2SecureHasher;
import org.apache.nifi.security.util.crypto.BcryptSecureHasher;
import org.apache.nifi.security.util.crypto.PBKDF2SecureHasher;
import org.apache.nifi.security.util.crypto.ScryptSecureHasher;
import org.apache.nifi.security.util.crypto.SecureHasher;
import org.apache.nifi.security.util.crypto.SecureHasherException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureHasherFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureHasherFactory.class);
    private static Map<KeyDerivationFunction, Class<? extends SecureHasher>> registeredSecureHashers;
    private static final Class<? extends SecureHasher> DEFAULT_SECURE_HASHER_CLASS;

    public static SecureHasher getSecureHasher(String algorithm) {
        Class<? extends SecureHasher> secureHasherClass = DEFAULT_SECURE_HASHER_CLASS;
        String algorithmPattern = algorithm.toUpperCase();
        try {
            for (KeyDerivationFunction keyDerivationFunction : registeredSecureHashers.keySet()) {
                String functionName = keyDerivationFunction.getKdfName().toUpperCase();
                if (!algorithmPattern.contains(functionName)) continue;
                secureHasherClass = registeredSecureHashers.get((Object)keyDerivationFunction);
            }
            LOGGER.debug("Creating SecureHasher [{}] for algorithm [{}]", (Object)secureHasherClass.getName(), (Object)algorithm);
            return secureHasherClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SecureHasherException(String.format("Failed to create SecureHasher for algorithm [%s]", algorithm), e);
        }
    }

    static {
        DEFAULT_SECURE_HASHER_CLASS = Argon2SecureHasher.class;
        registeredSecureHashers = new HashMap<KeyDerivationFunction, Class<? extends SecureHasher>>();
        registeredSecureHashers.put(KeyDerivationFunction.PBKDF2, PBKDF2SecureHasher.class);
        registeredSecureHashers.put(KeyDerivationFunction.BCRYPT, BcryptSecureHasher.class);
        registeredSecureHashers.put(KeyDerivationFunction.SCRYPT, ScryptSecureHasher.class);
        registeredSecureHashers.put(KeyDerivationFunction.ARGON2, Argon2SecureHasher.class);
    }
}

