/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.fastdouble;

import io.questdb.std.NumericException;
import io.questdb.std.fastdouble.FastFloat;
import io.questdb.std.fastdouble.FastFloatByteArray;
import io.questdb.std.fastdouble.FastFloatCharArray;

public final class FastFloatParser {
    private FastFloatParser() {
    }

    public static float parseFloat(CharSequence str, boolean rejectOverflow) throws NumericException {
        return FastFloatParser.parseFloat(str, 0, str.length(), rejectOverflow);
    }

    public static float parseFloat(CharSequence str, int offset, int length, boolean rejectOverflow) throws NumericException {
        return FastFloat.parseFloatingPointLiteral(str, offset, length, rejectOverflow);
    }

    public static float parseFloat(byte[] str, boolean rejectOverflow) throws NumericException {
        return FastFloatParser.parseFloat(str, 0, str.length, rejectOverflow);
    }

    public static float parseFloat(byte[] str, int offset, int length, boolean rejectOverflow) throws NumericException {
        return FastFloatByteArray.parseFloatingPointLiteral(str, offset, length, rejectOverflow);
    }

    public static float parseFloat(char[] str, boolean rejectOverflow) throws NumericException {
        return FastFloatParser.parseFloat(str, 0, str.length, rejectOverflow);
    }

    public static float parseFloat(char[] str, int offset, int length, boolean rejectOverflow) throws NumericException {
        return FastFloatCharArray.parseFloatingPointLiteral(str, offset, length, rejectOverflow);
    }
}

