/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.std.Chars;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Sinkable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import io.questdb.tasks.TableWriterTask;

public class TableSyncModel
implements Mutable,
Sinkable {
    public static final int COLUMN_META_ACTION_ADD = 4;
    public static final int COLUMN_META_ACTION_MOVE = 2;
    public static final int COLUMN_META_ACTION_REMOVE = 3;
    public static final int COLUMN_META_ACTION_REPLACE = 1;
    public static final int PARTITION_ACTION_APPEND = 1;
    public static final int PARTITION_ACTION_WHOLE = 0;
    public static final int TABLE_ACTION_KEEP = 0;
    public static final int TABLE_ACTION_TRUNCATE = 1;
    static final String[] ACTION_NAMES = new String[]{"whole", "append"};
    private static final int SLOTS_PER_COLUMN_META_INDEX = 2;
    private static final int SLOTS_PER_COLUMN_TOP = 4;
    private static final int SLOTS_PER_PARTITION = 8;
    private static final int SLOTS_PER_VAR_COLUMN_SIZE = 4;
    private final ObjList<TableColumnMetadata> addedColumnMetadata = new ObjList();
    private final LongList columnMetaIndex = new LongList();
    private final LongList columnTops = new LongList();
    private final LongList partitions = new LongList();
    private final LongList varColumnSizes = new LongList();
    private long dataVersion;
    private long maxTimestamp;
    private int tableAction = 0;

    public void addColumnMetaAction(int action, int from, int to) {
        this.columnMetaIndex.add((long)action, Numbers.encodeLowHighInts(from, to));
    }

    public void addColumnMetadata(TableColumnMetadata columnMetadata) {
        assert (columnMetadata.getType() > 0);
        this.addedColumnMetadata.add(columnMetadata);
    }

    public void addColumnTop(long timestamp, int columnIndex, long topValue) {
        this.columnTops.add(timestamp, columnIndex, topValue, 0L);
    }

    public void addPartitionAction(long action, long timestamp, long startRow, long rowCount, long nameTxn, long columnVersion) {
        this.partitions.add(action, timestamp, startRow, rowCount, nameTxn, columnVersion, 0L, 0L);
    }

    public void addVarColumnSize(long timestamp, int columnIndex, long size) {
        this.varColumnSizes.add(timestamp, columnIndex, size, 0L);
    }

    @Override
    public void clear() {
        this.partitions.clear();
        this.columnMetaIndex.clear();
        this.tableAction = 0;
        this.columnTops.clear();
        this.varColumnSizes.clear();
        this.addedColumnMetadata.clear();
    }

    public void fromBinary(long mem) {
        int i;
        int i2;
        long p = mem;
        this.tableAction = Unsafe.getUnsafe().getInt(p);
        this.dataVersion = Unsafe.getUnsafe().getLong(p += 4L);
        this.maxTimestamp = Unsafe.getUnsafe().getLong(p += 8L);
        int n = Unsafe.getUnsafe().getInt(p += 8L);
        p += 4L;
        for (i2 = 0; i2 < n; i2 += 4) {
            this.columnTops.add(Unsafe.getUnsafe().getLong(p), Unsafe.getUnsafe().getInt(p + 8L), Unsafe.getUnsafe().getLong(p + 12L), 0L);
            p += 20L;
        }
        n = Unsafe.getUnsafe().getInt(p);
        p += 4L;
        for (i2 = 0; i2 < n; i2 += 4) {
            this.varColumnSizes.add(Unsafe.getUnsafe().getLong(p), Unsafe.getUnsafe().getInt(p + 8L), Unsafe.getUnsafe().getLong(p + 12L), 0L);
            p += 20L;
        }
        n = Unsafe.getUnsafe().getInt(p);
        p += 4L;
        for (i2 = 0; i2 < n; i2 += 8) {
            this.partitions.add(Unsafe.getUnsafe().getInt(p), Unsafe.getUnsafe().getLong(p + 4L), Unsafe.getUnsafe().getLong(p + 12L), Unsafe.getUnsafe().getLong(p + 20L), Unsafe.getUnsafe().getLong(p + 28L), Unsafe.getUnsafe().getLong(p + 36L), 0L, 0L);
            p += 44L;
        }
        n = Unsafe.getUnsafe().getInt(p);
        p += 4L;
        StringSink nameSink = Misc.getThreadLocalBuilder();
        for (i = 0; i < n; ++i) {
            int nameLen = Unsafe.getUnsafe().getInt(p);
            long lim = (p += 4L) + (long)nameLen * 2L;
            while (p < lim) {
                nameSink.put(Unsafe.getUnsafe().getChar(p));
                p += 2L;
            }
            int type = Unsafe.getUnsafe().getInt(p);
            p += 4L;
            p += 8L;
            boolean indexed = Unsafe.getUnsafe().getByte(p++) == 0;
            int valueBlockCapacity = Unsafe.getUnsafe().getInt(p);
            p += 4L;
            this.addedColumnMetadata.add(new TableColumnMetadata(Chars.toString(nameSink), type, indexed, valueBlockCapacity, true, null));
        }
        n = Unsafe.getUnsafe().getInt(p);
        p += 4L;
        for (i = 0; i < n; i += 2) {
            this.columnMetaIndex.add((long)Unsafe.getUnsafe().getInt(p), Unsafe.getUnsafe().getLong(p + 4L));
            p += 12L;
        }
    }

    public int getPartitionCount() {
        return this.partitions.size() / 8;
    }

    public int getTableAction() {
        return this.tableAction;
    }

    public void setDataVersion(long dataVersion) {
        this.dataVersion = dataVersion;
    }

    public void setMaxTimestamp(long maxTimestamp) {
        this.maxTimestamp = maxTimestamp;
    }

    public void setTableAction(int tableAction) {
        this.tableAction = tableAction;
    }

    public void toBinary(TableWriterTask sink) {
        int i;
        sink.putInt(this.tableAction);
        sink.putLong(this.dataVersion);
        sink.putLong(this.maxTimestamp);
        int n = this.columnTops.size();
        sink.putInt(n);
        if (n > 0) {
            for (i = 0; i < n; i += 4) {
                sink.putLong(this.columnTops.getQuick(i));
                sink.putInt((int)this.columnTops.getQuick(i + 1));
                sink.putLong(this.columnTops.getQuick(i + 2));
            }
        }
        n = this.varColumnSizes.size();
        sink.putInt(n);
        if (n > 0) {
            for (i = 0; i < n; i += 4) {
                sink.putLong(this.varColumnSizes.getQuick(i));
                sink.putInt((int)this.varColumnSizes.getQuick(i + 1));
                sink.putLong(this.varColumnSizes.getQuick(i + 2));
            }
        }
        n = this.partitions.size();
        sink.putInt(n);
        for (i = 0; i < n; i += 8) {
            sink.putInt((int)this.partitions.getQuick(i));
            sink.putLong(this.partitions.getQuick(i + 1));
            sink.putLong(this.partitions.getQuick(i + 2));
            sink.putLong(this.partitions.getQuick(i + 3));
            sink.putLong(this.partitions.getQuick(i + 4));
            sink.putLong(this.partitions.getQuick(i + 5));
        }
        n = this.addedColumnMetadata.size();
        sink.putInt(n);
        for (i = 0; i < n; ++i) {
            TableColumnMetadata metadata = this.addedColumnMetadata.getQuick(i);
            sink.putStr(metadata.getName());
            sink.putInt(metadata.getType());
            sink.putLong(0L);
            sink.putByte((byte)(!metadata.isIndexed() ? 1 : 0));
            sink.putInt(metadata.getIndexValueBlockCapacity());
        }
        n = this.columnMetaIndex.size();
        sink.putInt(n);
        for (i = 0; i < n; i += 2) {
            sink.putInt((int)this.columnMetaIndex.getQuick(i));
            sink.putLong(this.columnMetaIndex.getQuick(i + 1));
        }
    }

    @Override
    public void toSink(CharSink sink) {
        int i;
        sink.put('{');
        sink.putQuoted("table").put(':').put('{');
        sink.putQuoted("action").put(':');
        switch (this.tableAction) {
            case 0: {
                sink.putQuoted("keep");
                break;
            }
            case 1: {
                sink.putQuoted("truncate");
                break;
            }
            case 2: {
                sink.putQuoted("replace");
            }
        }
        sink.put(',');
        sink.putQuoted("dataVersion").put(':').put(this.dataVersion);
        sink.put(',');
        sink.put("maxTimestamp").put(':').put('\"').putISODate(this.maxTimestamp).put('\"');
        sink.put('}');
        int n = this.columnTops.size();
        if (n > 0) {
            sink.put(',');
            sink.putQuoted("columnTops").put(':').put('[');
            for (i = 0; i < n; i += 4) {
                if (i > 0) {
                    sink.put(',');
                }
                sink.put('{');
                sink.putQuoted("ts").put(':').put('\"').putISODate(this.columnTops.getQuick(i)).put('\"').put(',');
                sink.putQuoted("index").put(':').put(this.columnTops.getQuick(i + 1)).put(',');
                sink.putQuoted("top").put(':').put(this.columnTops.getQuick(i + 2));
                sink.put('}');
            }
            sink.put(']');
        }
        if ((n = this.varColumnSizes.size()) > 0) {
            sink.put(',');
            sink.putQuoted("varColumns").put(':').put('[');
            for (i = 0; i < n; i += 4) {
                if (i > 0) {
                    sink.put(',');
                }
                sink.put('{');
                sink.putQuoted("ts").put(':').put('\"').putISODate(this.varColumnSizes.getQuick(i)).put('\"').put(',');
                sink.putQuoted("index").put(':').put(this.varColumnSizes.getQuick(i + 1)).put(',');
                sink.putQuoted("size").put(':').put(this.varColumnSizes.getQuick(i + 2));
                sink.put('}');
            }
            sink.put(']');
        }
        if ((n = this.partitions.size()) > 0) {
            sink.put(',');
            sink.putQuoted("partitions").put(':').put('[');
            for (i = 0; i < n; i += 8) {
                if (i > 0) {
                    sink.put(',');
                }
                sink.put('{');
                sink.putQuoted("action").put(':').putQuoted(ACTION_NAMES[(int)this.partitions.getQuick(i)]).put(',');
                sink.putQuoted("ts").put(':').put('\"').putISODate(this.partitions.getQuick(i + 1)).put('\"').put(',');
                sink.putQuoted("startRow").put(':').put(this.partitions.getQuick(i + 2)).put(',');
                sink.putQuoted("rowCount").put(':').put(this.partitions.getQuick(i + 3)).put(',');
                sink.putQuoted("nameTxn").put(':').put(this.partitions.getQuick(i + 4)).put(',');
                sink.putQuoted("columnVersion").put(':').put(this.partitions.getQuick(i + 5));
                sink.put('}');
            }
            sink.put(']');
        }
        if ((n = this.addedColumnMetadata.size()) > 0) {
            sink.put(',');
            sink.putQuoted("columnMetaData").put(':').put('[');
            for (i = 0; i < n; ++i) {
                if (i > 0) {
                    sink.put(',');
                }
                sink.put('{');
                TableColumnMetadata metadata = this.addedColumnMetadata.getQuick(i);
                sink.putQuoted("name").put(':').putQuoted(metadata.getName()).put(',');
                sink.putQuoted("type").put(':').putQuoted(ColumnType.nameOf(metadata.getType())).put(',');
                sink.putQuoted("index").put(':').put(metadata.isIndexed()).put(',');
                sink.putQuoted("indexCapacity").put(':').put(metadata.getIndexValueBlockCapacity());
                sink.put('}');
            }
            sink.put(']');
        }
        if ((n = this.columnMetaIndex.size()) > 0) {
            sink.put(',');
            sink.putQuoted("columnMetaIndex").put(':').put('[');
            for (i = 0; i < n; i += 2) {
                if (i > 0) {
                    sink.put(',');
                }
                int action = (int)this.columnMetaIndex.getQuick(i);
                sink.put('{');
                sink.putQuoted("action").put(':');
                switch (action) {
                    case 1: {
                        sink.putQuoted("replace");
                        break;
                    }
                    case 2: {
                        sink.putQuoted("move");
                        break;
                    }
                    case 3: {
                        sink.putQuoted("remove");
                        break;
                    }
                    case 4: {
                        sink.putQuoted("add");
                        break;
                    }
                }
                sink.put(',');
                long mix = this.columnMetaIndex.getQuick(i + 1);
                sink.putQuoted("fromIndex").put(':').put(Numbers.decodeLowInt(mix)).put(',');
                sink.putQuoted("toIndex").put(':').put(Numbers.decodeHighInt(mix));
                sink.put('}');
            }
            sink.put(']');
        }
        sink.put('}');
    }
}

