/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.view;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.myfaces.shared.view.ResponseSwitch;
import org.apache.myfaces.shared.view.SwitchableOutputStream;
import org.apache.myfaces.shared.view.SwitchableWriter;

public class HttpServletResponseSwitch
extends HttpServletResponseWrapper
implements ResponseSwitch {
    private PrintWriter _switchableWriter;
    private SwitchableOutputStream _switchableOutputStream;
    private boolean _enabled = true;

    public HttpServletResponseSwitch(HttpServletResponse response) {
        super(response);
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public int getBufferSize() {
        if (this.isEnabled()) {
            return super.getBufferSize();
        }
        return 0;
    }

    public boolean isCommitted() {
        if (this.isEnabled()) {
            return super.isCommitted();
        }
        return false;
    }

    public void reset() {
        if (this.isEnabled()) {
            super.reset();
        }
    }

    public void resetBuffer() {
        if (this.isEnabled()) {
            super.resetBuffer();
        }
    }

    public void flushBuffer() throws IOException {
        if (this.isEnabled()) {
            super.flushBuffer();
        }
    }

    public void setResponse(ServletResponse response) {
        if (response instanceof HttpServletResponse && response != this.getResponse()) {
            this._switchableOutputStream = null;
            this._switchableWriter = null;
            super.setResponse(response);
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._switchableOutputStream == null) {
            this._switchableOutputStream = new SwitchableOutputStream(super.getOutputStream(), this);
        }
        return this._switchableOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._switchableWriter == null) {
            this._switchableWriter = new PrintWriter(new SwitchableWriter(super.getWriter(), this));
        }
        return this._switchableWriter;
    }
}

