/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.ChainsawAppenderHandler;
import org.apache.log4j.chainsaw.LogUI;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.chainsaw.prefs.MRUFileList;
import org.apache.log4j.spi.Decoder;
import org.apache.log4j.spi.LoggingEvent;

class FileLoadAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(FileLoadAction.class);
    Decoder decoder = null;
    private LogUI parent;
    private boolean remoteURL = false;

    public FileLoadAction(LogUI parent, Decoder decoder, String title, boolean isRemoteURL) {
        super(title);
        this.remoteURL = isRemoteURL;
        this.decoder = decoder;
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name = "";
        URL url = null;
        if (!this.remoteURL) {
            try {
                File selectedFile = SwingHelper.promptForFile(this.parent, null, "Load Events from XML file or zipped XML file...", true);
                if (selectedFile != null) {
                    url = selectedFile.toURI().toURL();
                    name = selectedFile.getName();
                }
            }
            catch (Exception selectedFile) {}
        } else {
            String urltext = JOptionPane.showInputDialog(this.parent, (Object)"<html>Please type in the <b>complete</b> URL to the remote XML source.</html>");
            if (urltext != null) {
                try {
                    url = new URL(urltext);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.parent, "'" + urltext + "' is not a valid URL.");
                }
            }
        }
        if (url != null) {
            FileLoadAction.importURL(this.parent.handler, this.decoder, name, url);
            MRUFileList.log4jMRU().opened(url);
        }
    }

    public static void importURL(final ChainsawAppenderHandler handler, final Decoder decoder, String name, URL url) {
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("hostname", "file");
        additionalProperties.put("application", name);
        decoder.setAdditionalProperties(additionalProperties);
        final URL urlToUse = url;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Vector events = decoder.decode(urlToUse);
                    Iterator iter = events.iterator();
                    while (iter.hasNext()) {
                        handler.append((LoggingEvent)iter.next());
                    }
                }
                catch (IOException e1) {
                    LOG.error(e1);
                }
                MRUFileList.log4jMRU().opened(urlToUse);
            }
        }).start();
    }
}

