/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.security.GroupPrincipal;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.shiro.SecurityUtils;

public class ShiroSubjectIdentityAdapter
implements Filter {
    private static final String SUBJECT_USER_GROUPS = "subject.userGroups";
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = auditService.getAuditor("audit", "knox", "knox");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        org.apache.shiro.subject.Subject subject = SecurityUtils.getSubject();
        subject.hasRole("authenticatedUser");
        CallableChain callableChain = new CallableChain(request, response, chain);
        SecurityUtils.getSubject().execute((Callable)callableChain);
    }

    private static class CallableChain
    implements Callable<Void> {
        private FilterChain chain = null;
        ServletRequest request = null;
        ServletResponse response = null;

        CallableChain(ServletRequest request, ServletResponse response, FilterChain chain) {
            this.request = request;
            this.response = response;
            this.chain = chain;
        }

        @Override
        public Void call() throws Exception {
            PrivilegedExceptionAction<Void> action = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    chain.doFilter(request, response);
                    return null;
                }
            };
            org.apache.shiro.subject.Subject shiroSubject = SecurityUtils.getSubject();
            if (shiroSubject == null || shiroSubject.getPrincipal() == null) {
                throw new IllegalStateException("Unable to determine authenticated user from Shiro, please check that your Knox Shiro configuration is correct");
            }
            String principal = shiroSubject.getPrincipal().toString();
            HashSet emptySet = new HashSet();
            HashSet<Object> principals = new HashSet<Object>();
            PrimaryPrincipal p = new PrimaryPrincipal(principal);
            principals.add(p);
            auditService.getContext().setUsername(principal);
            String sourceUri = (String)this.request.getAttribute("sourceRequestContextUrl");
            auditor.audit("authentication", sourceUri, "uri", "success");
            HashSet<String> userGroups = null;
            if (SecurityUtils.getSubject().getSession().getAttribute((Object)ShiroSubjectIdentityAdapter.SUBJECT_USER_GROUPS) != null) {
                userGroups = (HashSet<String>)SecurityUtils.getSubject().getSession().getAttribute((Object)ShiroSubjectIdentityAdapter.SUBJECT_USER_GROUPS);
            } else if (shiroSubject.getPrincipal() instanceof String) {
                userGroups = new HashSet<String>(shiroSubject.getPrincipals().asSet());
                userGroups.remove(principal);
            } else {
                HashSet shiroPrincipals = new HashSet(shiroSubject.getPrincipals().asSet());
                userGroups = new HashSet();
                Iterator iterator = shiroPrincipals.iterator();
                while (iterator.hasNext()) {
                    Principal shiroPrincipal = (Principal)iterator.next();
                    userGroups.add(shiroPrincipal.toString());
                }
            }
            for (String userGroup : userGroups) {
                GroupPrincipal gp = new GroupPrincipal(userGroup);
                principals.add(gp);
            }
            auditor.audit("authentication", sourceUri, "uri", "success", "Groups: " + userGroups);
            Subject subject = new Subject(true, principals, emptySet, emptySet);
            Subject.doAs(subject, action);
            return null;
        }
    }
}

