/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml.xdk;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.validation.Schema;
import oracle.xml.jaxp.JXDocumentBuilderFactory;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.xdk.XDKTransformer;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XDKParser
implements XMLParser {
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private DocumentBuilderFactory documentBuilderFactory = new JXDocumentBuilderFactory();
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;

    public XDKParser() {
        this.setNamespaceAware(true);
        this.setWhitespacePreserving(false);
    }

    @Override
    public void setNamespaceAware(boolean isNamespaceAware) {
        this.documentBuilderFactory.setNamespaceAware(isNamespaceAware);
    }

    @Override
    public void setWhitespacePreserving(boolean isWhitespacePreserving) {
        this.documentBuilderFactory.setIgnoringElementContentWhitespace(!isWhitespacePreserving);
    }

    @Override
    public int getValidationMode() {
        if (!this.documentBuilderFactory.isValidating()) {
            return 0;
        }
        try {
            if (this.documentBuilderFactory.getAttribute(SCHEMA_LANGUAGE) == null) {
                return 2;
            }
        }
        catch (IllegalArgumentException e) {
            return 2;
        }
        return 3;
    }

    @Override
    public void setValidationMode(int validationMode) {
        switch (validationMode) {
            case 0: {
                this.documentBuilderFactory.setValidating(false);
                return;
            }
            case 2: {
                this.documentBuilderFactory.setValidating(true);
                return;
            }
            case 3: {
                try {
                    this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
                    this.documentBuilderFactory.setValidating(true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return;
            }
        }
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void setXMLSchema(URL url) throws XMLPlatformException {
        if (url == null) {
            return;
        }
        try {
            this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
            this.documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, url.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            XMLPlatformException.xmlPlatformErrorResolvingXMLSchema(url, e);
        }
    }

    @Override
    public void setXMLSchemas(Object[] schemas) throws XMLPlatformException {
        if (schemas == null || schemas.length == 0) {
            return;
        }
        try {
            this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
            this.documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, schemas);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            XMLPlatformException.xmlPlatformErrorResolvingXMLSchemas(schemas, e);
        }
    }

    @Override
    public Document parse(InputSource inputSource) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(inputSource);
        }
        catch (SAXException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
        catch (IOException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
    }

    @Override
    public Document parse(File file) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(file);
        }
        catch (SAXParseException e) {
            throw XMLPlatformException.xmlPlatformSAXParseException(e);
        }
        catch (SAXException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
        catch (IOException e) {
            throw XMLPlatformException.xmlPlatformFileNotFoundException(file, e);
        }
    }

    @Override
    public Document parse(InputStream inputStream) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(inputStream);
        }
        catch (SAXParseException e) {
            throw XMLPlatformException.xmlPlatformSAXParseException(e);
        }
        catch (SAXException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
        catch (IOException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
    }

    @Override
    public Document parse(Reader reader) throws XMLPlatformException {
        InputSource inputSource = new InputSource(reader);
        return this.parse(inputSource);
    }

    @Override
    public Document parse(Source source) throws XMLPlatformException {
        XDKTransformer xformer = new XDKTransformer();
        DOMResult domResult = new DOMResult();
        xformer.transform(source, (Result)domResult);
        return (Document)domResult.getNode();
    }

    @Override
    public Document parse(URL url) throws XMLPlatformException {
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
        }
        catch (IOException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
        boolean hasThrownException = false;
        try {
            Document document = this.parse(inputStream);
            return document;
        }
        catch (RuntimeException e) {
            hasThrownException = true;
            throw e;
        }
        finally {
            block11: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (hasThrownException) break block11;
                    throw XMLPlatformException.xmlPlatformParseException(e);
                }
            }
        }
    }

    private DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(this.entityResolver);
            documentBuilder.setErrorHandler(this.errorHandler);
            return documentBuilder;
        }
        catch (ParserConfigurationException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
    }

    @Override
    public void setXMLSchema(Schema schema) {
        this.documentBuilderFactory.setSchema(schema);
    }

    @Override
    public Schema getXMLSchema() {
        return this.documentBuilderFactory.getSchema();
    }
}

