/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.filter.AclParser;
import org.apache.knox.gateway.filter.AclsAuthorizationMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.GroupPrincipal;
import org.apache.knox.gateway.security.ImpersonatedPrincipal;
import org.apache.knox.gateway.security.PrimaryPrincipal;

public class AclsAuthorizationFilter
implements Filter {
    private static AclsAuthorizationMessages log = (AclsAuthorizationMessages)MessagesFactory.get(AclsAuthorizationMessages.class);
    private static Auditor auditor = AuditServiceFactory.getAuditService().getAuditor("audit", "knox", "knox");
    private String resourceRole = null;
    private String aclProcessingMode = null;
    private AclParser parser = new AclParser();
    private ArrayList<String> adminGroups = new ArrayList();
    private ArrayList<String> adminUsers = new ArrayList();

    public void init(FilterConfig filterConfig) throws ServletException {
        String adminUsers;
        String adminGroups = filterConfig.getInitParameter("knox.admin.groups");
        if (adminGroups != null) {
            this.parseAdminGroupConfig(adminGroups);
        }
        if ((adminUsers = filterConfig.getInitParameter("knox.admin.users")) != null) {
            this.parseAdminUserConfig(adminUsers);
        }
        this.resourceRole = this.getInitParameter(filterConfig, "resource.role");
        log.initializingForResourceRole(this.resourceRole);
        this.aclProcessingMode = this.getInitParameter(filterConfig, this.resourceRole + ".acl.mode");
        if (this.aclProcessingMode == null) {
            this.aclProcessingMode = this.getInitParameter(filterConfig, "acl.mode");
            if (this.aclProcessingMode == null) {
                this.aclProcessingMode = "AND";
            }
        }
        log.aclProcessingMode(this.aclProcessingMode);
        String acls = this.getInitParameter(filterConfig, this.resourceRole + ".acl");
        this.parser.parseAcls(this.resourceRole, acls);
    }

    private String getInitParameter(FilterConfig filterConfig, String paramName) {
        return filterConfig.getInitParameter(paramName.toLowerCase(Locale.ROOT));
    }

    private void parseAdminGroupConfig(String groups) {
        Collections.addAll(this.adminGroups, groups.split(","));
    }

    private void parseAdminUserConfig(String users) {
        Collections.addAll(this.adminUsers, users.split(","));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean accessGranted = this.enforceAclAuthorizationPolicy(request, response, chain);
        log.accessGranted(accessGranted);
        String sourceUrl = (String)request.getAttribute("sourceRequestContextUrl");
        if (accessGranted) {
            auditor.audit("authorization", sourceUrl, "uri", "success");
            chain.doFilter(request, response);
        } else {
            auditor.audit("authorization", sourceUrl, "uri", "failure");
            this.sendForbidden((HttpServletResponse)response);
        }
    }

    protected boolean enforceAclAuthorizationPolicy(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletRequest req = (HttpServletRequest)request;
        if (this.parser.users.size() == 0 && this.parser.groups.size() == 0 && this.parser.ipv.getIPAddresses().size() == 0) {
            return true;
        }
        boolean userAccess = false;
        boolean groupAccess = false;
        boolean ipAddrAccess = false;
        Subject subject = Subject.getSubject(AccessController.getContext());
        Principal primaryPrincipal = (Principal)subject.getPrincipals(PrimaryPrincipal.class).toArray()[0];
        log.primaryPrincipal(primaryPrincipal.getName());
        Object[] impersonations = subject.getPrincipals(ImpersonatedPrincipal.class).toArray();
        if (impersonations.length > 0) {
            log.impersonatedPrincipal(((Principal)impersonations[0]).getName());
            userAccess = this.checkUserAcls((Principal)impersonations[0]);
            log.impersonatedPrincipalHasAccess(userAccess);
        } else {
            userAccess = this.checkUserAcls(primaryPrincipal);
            log.primaryPrincipalHasAccess(userAccess);
        }
        Object[] groups = subject.getPrincipals(GroupPrincipal.class).toArray();
        if (groups.length > 0) {
            groupAccess = this.checkGroupAcls(groups);
            log.groupPrincipalHasAccess(groupAccess);
        } else if (this.parser.anyGroup && "AND".equals(this.aclProcessingMode)) {
            groupAccess = true;
        }
        log.remoteIPAddress(req.getRemoteAddr());
        ipAddrAccess = this.checkRemoteIpAcls(req.getRemoteAddr());
        log.remoteIPAddressHasAccess(ipAddrAccess);
        if ("OR".equals(this.aclProcessingMode)) {
            if (this.parser.anyUser) {
                userAccess = false;
            }
            if (this.parser.anyGroup) {
                groupAccess = false;
            }
            if (this.parser.ipv.allowsAnyIP()) {
                ipAddrAccess = false;
            }
            return userAccess || groupAccess || ipAddrAccess;
        }
        if ("AND".equals(this.aclProcessingMode)) {
            return userAccess && groupAccess && ipAddrAccess;
        }
        return false;
    }

    private boolean checkRemoteIpAcls(String remoteAddr) {
        boolean allowed = false;
        if (remoteAddr == null) {
            return false;
        }
        allowed = this.parser.ipv.validateIpAddress(remoteAddr);
        return allowed;
    }

    boolean checkUserAcls(Principal user) {
        boolean allowed = false;
        if (user == null) {
            return false;
        }
        if (this.parser.anyUser) {
            allowed = true;
        } else if (this.parser.users.contains(user.getName())) {
            allowed = true;
        } else if (this.parser.users.contains("KNOX_ADMIN_USERS") && this.adminUsers.contains(user.getName())) {
            allowed = true;
        }
        return allowed;
    }

    boolean checkGroupAcls(Object[] userGroups) {
        boolean allowed = false;
        if (userGroups == null) {
            return false;
        }
        if (this.parser.anyGroup) {
            allowed = true;
        } else {
            allowed = this.hasAllowedPrincipal(this.parser.groups, userGroups);
            if (!allowed && this.parser.groups.contains("KNOX_ADMIN_GROUPS")) {
                allowed = this.hasAllowedPrincipal(this.adminGroups, userGroups);
            }
        }
        return allowed;
    }

    private boolean hasAllowedPrincipal(List<String> allowed, Object[] userGroups) {
        boolean rc = false;
        for (int i = 0; i < userGroups.length; ++i) {
            if (!allowed.contains(((Principal)userGroups[i]).getName())) continue;
            rc = true;
            break;
        }
        return rc;
    }

    private void sendForbidden(HttpServletResponse res) {
        this.sendErrorCode(res, 403);
    }

    private void sendErrorCode(HttpServletResponse res, int code) {
        try {
            res.sendError(code);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

