/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.AnonymousProfile;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.InternalAttributeHandler;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProfileHelper {
    private static final Logger logger = LoggerFactory.getLogger(ProfileHelper.class);
    private static final Map<String, Constructor<? extends CommonProfile>> constructorsCache = new ConcurrentHashMap<String, Constructor<? extends CommonProfile>>();
    private static InternalAttributeHandler internalAttributeHandler = new InternalAttributeHandler();

    private ProfileHelper() {
    }

    public static boolean isTypedIdOf(String id, Class<? extends CommonProfile> clazz) {
        if (id != null && clazz != null) {
            return id.startsWith(clazz.getName() + "#");
        }
        return false;
    }

    public static CommonProfile restoreOrBuildProfile(ProfileDefinition<? extends CommonProfile> profileDefinition, String typedId, Map<String, Object> profileAttributes, Map<String, Object> authenticationAttributes, Object ... parameters) {
        CommonProfile profile;
        if (CommonHelper.isBlank(typedId)) {
            return null;
        }
        logger.info("Building user profile based on typedId: {}", (Object)typedId);
        if (typedId.contains("#")) {
            String className = CommonHelper.substringBefore(typedId, "#");
            try {
                profile = ProfileHelper.buildUserProfileByClassCompleteName(className);
            }
            catch (TechnicalException e) {
                logger.error("Cannot build instance for class name: {}", (Object)className, (Object)e);
                return null;
            }
            profile.addAttributes(profileAttributes);
            profile.addAuthenticationAttributes(authenticationAttributes);
        } else {
            profile = profileDefinition.newProfile(parameters);
            profileDefinition.convertAndAdd(profile, profileAttributes, authenticationAttributes);
        }
        profile.setId(ProfileHelper.sanitizeIdentifier(profile, typedId));
        return profile;
    }

    public static CommonProfile buildUserProfileByClassCompleteName(String completeName) {
        try {
            Constructor<? extends CommonProfile> constructor = ProfileHelper.getConstructor(completeName);
            return constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TechnicalException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Constructor<? extends CommonProfile> getConstructor(String name) throws ClassNotFoundException, NoSuchMethodException {
        Constructor<CommonProfile> constructor = constructorsCache.get(name);
        if (constructor == null) {
            Map<String, Constructor<? extends CommonProfile>> map = constructorsCache;
            synchronized (map) {
                constructor = constructorsCache.get(name);
                if (constructor == null) {
                    ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                    constructor = tccl == null ? Class.forName(name).getDeclaredConstructor(new Class[0]) : Class.forName(name, true, tccl).getDeclaredConstructor(new Class[0]);
                    constructorsCache.put(name, constructor);
                }
            }
        }
        return constructor;
    }

    public static <U extends CommonProfile> Optional<U> flatIntoOneProfile(Collection<U> profiles) {
        Optional<CommonProfile> profile = profiles.stream().filter(p -> p != null && !(p instanceof AnonymousProfile)).findFirst();
        if (profile.isPresent()) {
            return profile;
        }
        return profiles.stream().filter(p -> p != null).findFirst();
    }

    public static <U extends CommonProfile> List<U> flatIntoAProfileList(Map<String, U> profiles) {
        return new ArrayList<U>(profiles.values());
    }

    public static String sanitizeIdentifier(UserProfile profile, Object id) {
        if (id != null) {
            String type;
            String sId = id.toString();
            if (profile != null && sId.startsWith(type = profile.getClass().getName() + "#")) {
                sId = sId.substring(type.length());
            }
            return sId;
        }
        return null;
    }

    public static InternalAttributeHandler getInternalAttributeHandler() {
        return internalAttributeHandler;
    }

    public static void setInternalAttributeHandler(InternalAttributeHandler internalAttributeHandler) {
        ProfileHelper.internalAttributeHandler = internalAttributeHandler;
    }
}

