/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.Collection;
import java.util.Iterator;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatFactory;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.support.ResolverHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiDataFormatResolver
implements DataFormatResolver {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiDataFormatResolver.class);
    private final BundleContext bundleContext;

    public OsgiDataFormatResolver(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public DataFormat createDataFormat(String name, CamelContext context) {
        DataFormat dataFormat = null;
        DataFormatFactory dataFormatFactory = ResolverHelper.lookupDataFormatFactoryInRegistryWithFallback((CamelContext)context, (String)name);
        if (dataFormatFactory != null) {
            dataFormat = dataFormatFactory.newInstance();
        }
        if (dataFormat == null) {
            dataFormat = this.getDataFormat(name, context);
        }
        return dataFormat;
    }

    private DataFormat getDataFormat(String name, CamelContext context) {
        LOG.trace("Finding DataFormat: {}", (Object)name);
        try {
            Iterator iterator;
            Collection refs = this.bundleContext.getServiceReferences(DataFormatResolver.class, "(dataformat=" + name + ")");
            if (refs != null && (iterator = refs.iterator()).hasNext()) {
                ServiceReference ref = (ServiceReference)iterator.next();
                return ((DataFormatResolver)this.bundleContext.getService(ref)).createDataFormat(name, context);
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

