/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;

@Command(scope="shell", name="tac", description="Captures the STDIN and returns it as a string. Optionally writes the content to a file.")
@Service
public class TacAction
implements Action {
    @Option(name="-f", aliases={}, description="Outputs the content to the given file", required=false, multiValued=false)
    private File file;
    @Reference
    Session session;

    public Object execute() throws Exception {
        StringWriter sw = new StringWriter();
        Writer[] writers = this.file != null ? new Writer[]{sw, new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.file)))} : new Writer[]{sw};
        BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
        String s = rdr.readLine();
        boolean first = true;
        while (s != null) {
            for (Writer w : writers) {
                if (!first) {
                    w.write("\n");
                }
                w.write(s);
            }
            first = false;
            s = rdr.readLine();
        }
        for (Writer w : writers) {
            w.close();
        }
        return sw.toString();
    }
}

