/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.command;

import java.util.Map;
import org.apache.karaf.log.command.LogCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.table.ShellTable;

@Command(scope="log", name="get", description="Shows the currently set log level.")
public class GetLogLevel
extends LogCommandSupport {
    @Argument(index=0, name="logger", description="The name of the logger, ALL or ROOT (default)", required=false, multiValued=false)
    String logger;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;

    protected Object doExecute() throws Exception {
        Map loggers = this.logService.getLevel(this.logger);
        ShellTable table = new ShellTable();
        table.column("Logger");
        table.column("Level");
        for (String logger : loggers.keySet()) {
            table.addRow().addContent(new Object[]{logger, loggers.get(logger)});
        }
        table.print(System.out, !this.noFormat);
        return null;
    }
}

