/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.region.persist.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.karaf.region.persist.RegionsPersistence;
import org.apache.karaf.region.persist.internal.RegionsBundleTracker;
import org.apache.karaf.region.persist.internal.RegionsPersistenceImpl;
import org.apache.karaf.region.persist.internal.util.SingleServiceTracker;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger log = LoggerFactory.getLogger(Activator.class);
    private SingleServiceTracker<RegionDigraph> tracker;
    private final AtomicReference<RegionsPersistenceImpl> persistence = new AtomicReference();
    private final AtomicReference<RegionsBundleTracker> bundleTracker = new AtomicReference();
    private ServiceRegistration<RegionsPersistence> reg;

    public void start(final BundleContext bundleContext) throws Exception {
        this.tracker = new SingleServiceTracker<RegionDigraph>(bundleContext, RegionDigraph.class, new SingleServiceTracker.SingleServiceListener(){

            @Override
            public void serviceFound() {
                log.debug("Found RegionDigraph service, initializing");
                RegionDigraph regionDigraph = (RegionDigraph)Activator.this.tracker.getService();
                Bundle framework = bundleContext.getBundle(0L);
                RegionsPersistenceImpl persistence = null;
                try {
                    persistence = new RegionsPersistenceImpl(regionDigraph, Activator.this.tracker.getServiceReference().getBundle(), framework);
                    Activator.this.reg = bundleContext.registerService(RegionsPersistence.class, (Object)persistence, null);
                    RegionsBundleTracker bundleTracker = new RegionsBundleTracker();
                    bundleTracker.start(bundleContext, persistence);
                    Activator.this.bundleTracker.set(bundleTracker);
                }
                catch (Exception e) {
                    log.info("Could not create RegionsPersistenceImpl", (Throwable)e);
                }
                Activator.this.persistence.set(persistence);
            }

            @Override
            public void serviceLost() {
                if (Activator.this.reg != null) {
                    Activator.this.reg.unregister();
                    Activator.this.reg = null;
                }
                Activator.this.persistence.set(null);
                Activator.this.bundleTracker.set(null);
            }

            @Override
            public void serviceReplaced() {
            }
        });
        this.tracker.open();
        bundleContext.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
                RegionsPersistence persist;
                if ((bundleEvent.getType() == 1 || bundleEvent.getType() == 16) && (persist = (RegionsPersistence)Activator.this.persistence.get()) != null) {
                    try {
                        persist.save();
                    }
                    catch (Exception e) {
                        log.warn("Unable to persist region digraph", (Throwable)e);
                    }
                }
            }
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.tracker.close();
        this.persistence.set(null);
        this.bundleTracker.set(null);
    }
}

