/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.AssertionPredicates;
import org.apache.juneau.assertions.FluentAnyAssertion;
import org.apache.juneau.assertions.FluentCollectionAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentStringListAssertion;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.Messages;

public class FluentListAssertion<E, R>
extends FluentCollectionAssertion<E, R> {
    private static final Messages MESSAGES = Messages.of(FluentListAssertion.class, "Messages");
    private static final String MSG_listDidNotContainExpectedValueAt = MESSAGES.getString("listDidNotContainExpectedValueAt");

    public FluentListAssertion(Assertion creator, List<E> value, R returns) {
        super(creator, value, returns);
    }

    public FluentListAssertion(List<E> value, R returns) {
        this((Assertion)null, value, returns);
    }

    public FluentListAssertion<E, R> asApplied2(Function<List<E>, List<E>> function) {
        return new FluentListAssertion((Assertion)this, function.apply(this.orElse(null)), this.returns());
    }

    public FluentStringAssertion<R> asCdl() {
        return new FluentStringAssertion((Assertion)this, this.valueIsNull() ? null : StringUtils.join(this.value(), ','), this.returns());
    }

    public FluentStringAssertion<R> asCdl(Function<E, String> function) {
        List<String> l = this.valueIsNull() ? null : this.value().stream().map(function::apply).toList();
        return new FluentStringAssertion((Assertion)this, StringUtils.join(l, ','), this.returns());
    }

    public FluentAnyAssertion<E, R> asFirst() {
        return this.asItem(0);
    }

    public FluentListAssertion<E, R> asFirst(int count) {
        return new FluentListAssertion((Assertion)this, this.valueIsNull() ? null : this.value().subList(0, count), this.returns());
    }

    public FluentAnyAssertion<E, R> asItem(int index) {
        return new FluentAnyAssertion(this, this.at(index), this.returns());
    }

    public FluentAnyAssertion<E, R> asLast() {
        return this.asItem(this.getSize() - 1);
    }

    public FluentListAssertion<E, R> asLast(int count) {
        return new FluentListAssertion((Assertion)this, this.valueIsNull() ? null : this.value().subList(this.getSize() - count, this.getSize()), this.returns());
    }

    public FluentListAssertion<E, R> asSorted() {
        return new FluentListAssertion((Assertion)this, this.toSortedList(null), this.returns());
    }

    public FluentListAssertion<E, R> asSorted(Comparator<E> comparator) {
        return new FluentListAssertion((Assertion)this, this.toSortedList(comparator), this.returns());
    }

    public FluentStringListAssertion<R> asStrings(Function<E, String> function) {
        List<String> l = this.valueIsNull() ? null : this.value().stream().map(function::apply).toList();
        return new FluentStringListAssertion((Assertion)this, l, this.returns());
    }

    public FluentListAssertion<E, R> asSublist(int start, int end) {
        return new FluentListAssertion((Assertion)this, this.valueIsNull() ? null : this.value().subList(start, end), this.returns());
    }

    @SafeVarargs
    public final R isEach(Predicate<E> ... tests) throws AssertionError {
        this.isSize(tests.length);
        int j = this.getSize();
        for (int i = 0; i < j; ++i) {
            Predicate<E> t = tests[i];
            if (!Utils.nn(t) || t.test(this.at(i))) continue;
            throw this.error(MSG_listDidNotContainExpectedValueAt, i, this.getFailureMessage(t, this.at(i)));
        }
        return this.returns();
    }

    public R isHas(E ... entries) throws AssertionError {
        Predicate[] p = (Predicate[])CollectionUtils.stream(entries).map(AssertionPredicates::eq).toArray(Predicate[]::new);
        return this.isEach(p);
    }

    @Override
    public FluentListAssertion<E, R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentListAssertion<E, R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentListAssertion<E, R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentListAssertion<E, R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentListAssertion<E, R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    private E at(int index) throws AssertionError {
        return this.valueIsNull() || index < 0 || index >= this.getSize() ? null : (E)this.value().get(index);
    }

    private List<E> toSortedList(Comparator<E> comparator) {
        return this.valueIsNull() ? null : CollectionUtils.sortedList(comparator, this.value());
    }

    @Override
    protected List<E> value() throws AssertionError {
        return (List)super.value();
    }
}

