/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.junit.bct.annotations;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.juneau.commons.lang.TriState;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.junit.bct.BasicBeanConverter;
import org.apache.juneau.junit.bct.BctConfiguration;
import org.apache.juneau.junit.bct.BeanConverter;
import org.apache.juneau.junit.bct.annotations.BctConfig;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class BctConfigExtension
implements BeforeEachCallback,
AfterEachCallback {
    public void beforeEach(ExtensionContext context) throws Exception {
        List<BctConfig> al = BctConfigExtension.getAnnotations(context);
        if (al.isEmpty()) {
            return;
        }
        BctConfiguration.clear();
        al.stream().map(x -> x.sortMaps()).filter(x -> Utils.neq((Object)x, (Object)TriState.UNSET)).findFirst().ifPresent(x -> BctConfiguration.set("Bct.sortMaps", x == TriState.TRUE));
        al.stream().map(x -> x.sortCollections()).filter(x -> Utils.neq((Object)x, (Object)TriState.UNSET)).findFirst().ifPresent(x -> BctConfiguration.set("Bct.sortCollections", x == TriState.TRUE));
        al.stream().map(x -> x.beanConverter()).filter(x -> Utils.neq((Object)x, BeanConverter.class)).findFirst().map(x -> Utils.eq((Object)x, BasicBeanConverter.class) ? null : x).ifPresent(x -> BctConfigExtension.setConverter(x));
    }

    private static void setConverter(Class<? extends BeanConverter> x) {
        Utils.safe(() -> {
            Constructor c = x.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            BctConfiguration.set((BeanConverter)c.newInstance(new Object[0]));
        }, e -> ThrowableUtils.rex((Throwable)e, (String)"Failed to instantiate BeanConverter: {0}. It must have a no-arg constructor.", (Object[])new Object[]{x.getName()}));
    }

    public void afterEach(ExtensionContext context) throws Exception {
        List<BctConfig> al = BctConfigExtension.getAnnotations(context);
        if (al.isEmpty()) {
            return;
        }
        BctConfiguration.clear();
    }

    private static List<BctConfig> getAnnotations(ExtensionContext context) {
        ArrayList<BctConfig> l = new ArrayList<BctConfig>();
        context.getTestMethod().map(x -> x.getAnnotation(BctConfig.class)).ifPresent(x -> l.add((BctConfig)x));
        context.getTestClass().map(x -> x.getAnnotation(BctConfig.class)).ifPresent(x -> l.add((BctConfig)x));
        return l;
    }
}

