/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean;

import java.net.URI;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.html.annotation.HtmlLink;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.serializer.SerializeException;

@HtmlLink
@Bean(findFluentSetters=true)
public class LinkString
implements Comparable<LinkString> {
    private String name;
    private URI uri;

    public LinkString() {
    }

    public LinkString(String name, String uri, Object ... uriArgs) {
        this.setName(name);
        this.setUri(uri, uriArgs);
    }

    @Override
    public int compareTo(LinkString o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        LinkString o2;
        return o instanceof LinkString && Utils.eq((Object)this, (Object)(o2 = (LinkString)o), (x, y) -> x.name.equals(y.name));
    }

    public String getName() {
        return this.name;
    }

    public URI getUri() {
        return this.uri;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public LinkString setName(String value) {
        this.name = value;
        return this;
    }

    public LinkString setUri(URI value) {
        this.uri = value;
        return this;
    }

    public LinkString setUri(String value) {
        this.setUri(value, new Object[0]);
        return this;
    }

    public LinkString setUri(String value, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            try {
                args[i] = OpenApiSerializer.DEFAULT.getSession().serialize(HttpPartType.PATH, null, args[i]);
                continue;
            }
            catch (SchemaValidationException | SerializeException e) {
                throw ThrowableUtils.toRex((Throwable)e);
            }
        }
        this.uri = URI.create(Utils.f((String)value, (Object[])args));
        return this;
    }

    public String toString() {
        return this.name;
    }
}

